/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import org.jenkinsci.plugins.p4.credentials.P4Credentials;
import org.jenkinsci.plugins.p4.credentials.TrustImpl;

public abstract class P4BaseCredentials
extends BaseStandardCredentials
implements P4Credentials {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String p4port;
    @CheckForNull
    private final TrustImpl ssl;
    @NonNull
    private final String username;
    @CheckForNull
    private final String retry;
    @CheckForNull
    private final String timeout;
    @CheckForNull
    private final String p4host;

    public P4BaseCredentials(CredentialsScope scope, String id, String description, @NonNull String p4port, @CheckForNull TrustImpl ssl, @NonNull String username, @CheckForNull String retry, @CheckForNull String timeout, @CheckForNull String p4host) {
        super(scope, id, description);
        this.p4port = Util.fixNull((String)p4port);
        this.ssl = ssl;
        this.username = Util.fixNull((String)username);
        this.retry = retry;
        this.timeout = timeout;
        this.p4host = p4host;
    }

    @Override
    public String getP4port() {
        return this.p4port;
    }

    public String getP4JavaUri() {
        if (this.isSsl()) {
            return "p4javassl://" + this.p4port;
        }
        if (this.p4port.startsWith("rsh:")) {
            String trim = this.p4port.substring(4, this.p4port.length());
            return "p4jrsh://" + trim + " --java";
        }
        return "p4java://" + this.p4port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl != null;
    }

    @Override
    @CheckForNull
    public String getTrust() {
        return this.ssl == null ? null : this.ssl.getTrust();
    }

    public String getUsername() {
        return this.username;
    }

    public int getRetry() {
        if (this.retry != null && !this.retry.isEmpty()) {
            return Integer.parseInt(this.retry);
        }
        return 0;
    }

    public int getTimeout() {
        if (this.timeout != null && !this.timeout.isEmpty()) {
            return Integer.parseInt(this.timeout);
        }
        return 0;
    }

    public String getP4host() {
        return this.p4host == null ? "" : this.p4host;
    }
}

