/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import java.util.List;

public class ViewMapHelper {
    private static final String QUOTE = "\"";
    private static final String MAP_SEP = " ";
    private static final String MAP_DELIM = "\n";
    private static final String PATH_DELIM = "/";
    private static final String EXCLUDE = "-";
    private static final String INCLUDE = "+";

    public static String getClientView(String depotView, String client, boolean overlay) {
        if (depotView == null || depotView.isEmpty()) {
            return null;
        }
        if (client == null || client.isEmpty()) {
            return null;
        }
        String[] lines = depotView.trim().split("\n\\s*");
        boolean multi = lines.length > 1;
        StringBuffer view = ViewMapHelper.processLines(lines, client, multi, overlay);
        return view.toString();
    }

    public static String getClientView(List<String> views, String client, boolean external, boolean overlay) {
        if (views == null || views.isEmpty()) {
            return null;
        }
        if (client == null || client.isEmpty()) {
            return null;
        }
        StringBuffer view = ViewMapHelper.processLines(views.toArray(new String[0]), client, external, overlay);
        return view.toString();
    }

    public static String getScriptView(String base, String scriptPath, String client) {
        if (client == null || client.isEmpty()) {
            return null;
        }
        StringBuffer lhs = new StringBuffer("");
        lhs.append(base);
        lhs.append(PATH_DELIM);
        lhs.append(scriptPath);
        StringBuffer rhs = new StringBuffer("//");
        rhs.append(client);
        rhs.append(PATH_DELIM);
        rhs.append(scriptPath);
        if (base.contains(MAP_SEP) || scriptPath.contains(MAP_SEP)) {
            lhs = ViewMapHelper.wrapSpaces(lhs);
            rhs = ViewMapHelper.wrapSpaces(rhs);
        }
        StringBuffer view = new StringBuffer();
        view.append(lhs);
        view.append(MAP_SEP);
        view.append(rhs);
        return view.toString();
    }

    public static String[] splitDepotPath(String path) {
        boolean exclude = path.startsWith(EXCLUDE);
        boolean include = path.startsWith(INCLUDE);
        String remove = "//";
        remove = exclude ? "-//" : remove;
        remove = include ? "+//" : remove;
        path = path.substring(remove.length());
        String[] parts = path.split(PATH_DELIM);
        return parts;
    }

    private static StringBuffer processLines(String[] lines, String client, boolean external, boolean overlay) {
        StringBuffer view = new StringBuffer();
        for (int c = 0; c < lines.length; ++c) {
            boolean spaces = lines[c].contains(MAP_SEP);
            boolean exclude = lines[c].startsWith(EXCLUDE);
            boolean include = lines[c].startsWith(INCLUDE);
            String[] parts = ViewMapHelper.splitDepotPath(lines[c]);
            include |= !external && overlay;
            StringBuffer lhs = ViewMapHelper.processLHS(parts);
            StringBuffer rhs = ViewMapHelper.processRHS(client, parts, external);
            if (exclude) {
                lhs.insert(0, EXCLUDE);
            } else if (include) {
                lhs.insert(0, INCLUDE);
            }
            if (spaces) {
                lhs = ViewMapHelper.wrapSpaces(lhs);
                rhs = ViewMapHelper.wrapSpaces(rhs);
            }
            if (c > 0) {
                view.append(MAP_DELIM);
            }
            view.append(lhs);
            view.append(MAP_SEP);
            view.append(rhs);
        }
        return view;
    }

    private static StringBuffer wrapSpaces(StringBuffer sb) {
        sb.insert(0, QUOTE);
        sb.append(QUOTE);
        return sb;
    }

    private static StringBuffer processLHS(String[] parts) {
        StringBuffer lhs = new StringBuffer("//");
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                lhs.append(PATH_DELIM);
            }
            lhs.append(parts[i]);
        }
        return lhs;
    }

    private static StringBuffer processRHS(String client, String[] parts, boolean external) {
        StringBuffer rhs = new StringBuffer("//");
        rhs.append(client);
        rhs.append(PATH_DELIM);
        if (external) {
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    rhs.append(PATH_DELIM);
                }
                rhs.append(parts[i]);
            }
        } else {
            rhs.append(parts[parts.length - 1]);
        }
        return rhs;
    }
}

