/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import hudson.model.Item;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;

public class TempClientHelper
extends ClientHelper
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(TempClientHelper.class.getName());
    private final String clientUUID;

    public TempClientHelper(Item context, String credential, TaskListener listener, Workspace workspace) throws Exception {
        super(context, credential, listener);
        String oldName = workspace.getName();
        this.clientUUID = "jenkinsTemp-" + UUID.randomUUID().toString();
        workspace.setName(this.clientUUID);
        if (workspace instanceof ManualWorkspaceImpl) {
            ManualWorkspaceImpl manual = (ManualWorkspaceImpl)workspace;
            WorkspaceSpec spec = manual.getSpec();
            String view = spec.getView();
            view = view.replace(oldName, this.clientUUID);
            spec.setView(view);
            manual.setSpec(spec);
        }
        this.clientLogin(workspace);
    }

    @Override
    public void close() throws IOException {
        try {
            this.deleteClient(this.clientUUID);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to remove temporary client: " + this.clientUUID);
        }
        this.disconnect();
    }

    public String getClientUUID() {
        return this.clientUUID;
    }
}

