/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.server.IOptionsServer;
import hudson.model.AutoCompletionCandidates;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;

public class NavigateHelper
implements Closeable {
    private final int max;
    private final IOptionsServer p4;
    private final String root;
    private List<Node> nodes;

    public NavigateHelper(IOptionsServer p4) {
        this.max = 0;
        this.p4 = p4;
        String client = p4.getCurrentClient().getName();
        this.root = "//" + client + "/";
    }

    public NavigateHelper(int max) {
        this.max = max;
        this.p4 = ConnectionFactory.getConnection();
        this.root = "";
    }

    public AutoCompletionCandidates getCandidates(String depotPath) {
        this.nodes = new ArrayList<Node>();
        this.buildPaths(depotPath);
        return this.getCandidates();
    }

    public List<Node> getNodes(String localPath) {
        this.nodes = new ArrayList<Node>();
        String path = this.root + localPath;
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        this.buildPaths(path);
        return this.nodes;
    }

    private void buildPaths(String value) {
        try {
            String depot;
            if (!value.startsWith("//")) {
                value = "//" + value;
            }
            if (!(depot = value.substring(2)).contains("/") && !this.listDepots(depot)) {
                return;
            }
            this.listDirs(value);
            this.listFiles(value);
        }
        catch (P4JavaException p4JavaException) {
            // empty catch block
        }
    }

    private boolean listDepots(String value) throws P4JavaException {
        if (this.p4 != null) {
            List list = this.p4.getDepots();
            for (IDepot l : list) {
                if (l.getName().equals(value)) {
                    this.nodes = new ArrayList<Node>();
                    return true;
                }
                if (!l.getName().startsWith(value)) continue;
                this.nodes.add(new Node("//" + l.getName(), true));
            }
        }
        return false;
    }

    private void listDirs(String value) throws P4JavaException {
        if (this.p4 != null && value.length() > 4) {
            GetDirectoriesOptions opts;
            List<IFileSpec> dirs = this.specBuilder(value);
            List list = this.p4.getDirectories(dirs, opts = new GetDirectoriesOptions());
            if (list == null) {
                return;
            }
            if (this.max > 0 && list.size() > this.max) {
                list = list.subList(0, this.max);
            }
            for (IFileSpec l : list) {
                String dir = l.getOriginalPathString();
                if (dir == null) continue;
                this.nodes.add(new Node(dir, true));
            }
        }
    }

    private void listFiles(String value) throws P4JavaException {
        if (this.p4 != null && value.length() > 4) {
            List<IFileSpec> files = this.specBuilder(value);
            GetDepotFilesOptions opts = new GetDepotFilesOptions();
            if (this.max > 0) {
                opts.setMaxResults(this.max);
            }
            List list = this.p4.getDepotFiles(files, opts);
            for (IFileSpec l : list) {
                if (!l.getOpStatus().equals((Object)FileSpecOpStatus.VALID)) continue;
                this.nodes.add(new Node(l.getDepotPathString(), false));
            }
        }
    }

    private List<IFileSpec> specBuilder(String value) {
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{value + "*"});
        return files;
    }

    private AutoCompletionCandidates getCandidates() {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        for (Node node : this.nodes) {
            c.add(node.getDepotPath());
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        try {
            this.p4.disconnect();
        }
        catch (P4JavaException e) {
            throw new IOException(e);
        }
    }

    public static final class Node {
        private String name;
        private String depotPath;
        private boolean isDir;

        protected Node(String depotPath, boolean isDir) {
            this.isDir = isDir;
            this.depotPath = depotPath;
            this.name = depotPath.substring(depotPath.lastIndexOf("/") + 1);
            if (isDir && !depotPath.endsWith("/")) {
                this.depotPath = depotPath + "/";
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDepotPath() {
            return this.depotPath;
        }

        public boolean isDir() {
            return this.isDir;
        }
    }
}

