/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.perforce.p4java.admin.IProperty;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.graph.ICommit;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.option.server.GetPropertyOptions;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.option.server.GraphCommitLogOptions;
import com.perforce.p4java.option.server.ReposOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import hudson.AbortException;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4GraphRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.AuthorisationConfig;
import org.jenkinsci.plugins.p4.client.ConnectionConfig;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.Validate;
import org.jenkinsci.plugins.p4.console.P4Logging;
import org.jenkinsci.plugins.p4.console.P4Progress;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;

public class ConnectionHelper
implements AutoCloseable {
    private static Logger logger = Logger.getLogger(ConnectionHelper.class.getName());
    private final TaskListener listener;
    private final P4BaseCredentials p4credential;
    private final ConnectionConfig connectionConfig;
    private final AuthorisationConfig authorisationConfig;
    private final Validate validate;
    private IOptionsServer connection;
    private boolean abort = false;
    private Boolean unicode = null;

    @Deprecated
    public ConnectionHelper(String credentialID, TaskListener listener) throws IOException {
        P4BaseCredentials credential;
        this.listener = listener;
        this.p4credential = credential = ConnectionHelper.findCredential(credentialID);
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
        this.validate = new Validate(listener);
    }

    public ConnectionHelper(ItemGroup context, String credentialID, TaskListener listener) throws IOException {
        this(ConnectionHelper.findCredential(credentialID, context), listener);
    }

    public ConnectionHelper(Item job, String credentialID, TaskListener listener) throws IOException {
        this(ConnectionHelper.findCredential(credentialID, job), listener);
    }

    public ConnectionHelper(Run run, String credentialID, TaskListener listener) throws IOException {
        this(ConnectionHelper.findCredential(credentialID, run), listener);
    }

    public ConnectionHelper(P4BaseCredentials credential, TaskListener listener) throws IOException {
        this.listener = listener;
        this.p4credential = credential;
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
        this.validate = new Validate(listener);
    }

    public ConnectionHelper(P4BaseCredentials credential) throws IOException {
        this.listener = new LogTaskListener(logger, Level.INFO);
        this.p4credential = credential;
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
        this.validate = new Validate(this.listener);
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public AuthorisationConfig getAuthorisationConfig() {
        return this.authorisationConfig;
    }

    public Validate getValidate() {
        return this.validate;
    }

    public IOptionsServer getConnection() {
        return this.connection;
    }

    private boolean connect() throws Exception {
        this.connection = ConnectionFactory.getConnection(this.connectionConfig);
        logger.fine("P4: opened connection OK");
        try {
            this.login();
        }
        catch (Exception e) {
            String err = "P4: Unable to login: " + e;
            logger.severe(err);
            this.log(err);
            return false;
        }
        P4Progress progress = new P4Progress(this.listener, this);
        this.connection.registerProgressCallback((IProgressCallback)progress);
        P4Logging logging = new P4Logging(this.listener);
        this.connection.registerCallback((ICommandCallback)logging);
        String ignore = ".p4ignore";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            ignore = "p4ignore.txt";
        }
        Server server = (Server)this.connection;
        server.setIgnoreFileName(ignore);
        return true;
    }

    private void connectionRetry() throws AbortException {
        int trys = 0;
        int attempt = this.getRetry();
        String err = "P4: Invalid credentials. Giving up...";
        while (trys <= attempt) {
            try {
                if (this.connect()) {
                    return;
                }
            }
            catch (Exception e) {
                err = e.getMessage();
            }
            String msg = "P4: Connection retry: " + ++trys;
            logger.severe(msg);
            this.log(msg);
            try {
                TimeUnit.SECONDS.sleep(trys ^ 2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        logger.severe(err);
        this.log(err);
        throw new AbortException(err);
    }

    public int getRetry() {
        return this.p4credential.getRetry();
    }

    public String getUser() {
        return this.p4credential.getUsername();
    }

    public String getPort() {
        return this.p4credential.getP4port();
    }

    public String getTrust() throws Exception {
        return this.connection.getTrust();
    }

    public String getTicket() {
        try {
            if (this.login()) {
                return this.connection.getAuthTicket();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isConnected();
    }

    public boolean isUnicode() throws ConnectionException, AccessException, RequestException {
        return this.connection.supportsUnicode();
    }

    public boolean checkVersion(int min) {
        int ver = this.connection.getServerVersionNumber();
        return ver >= min;
    }

    public boolean login() throws Exception {
        this.connection.setUserName(this.authorisationConfig.getUsername());
        if (this.isUnicode()) {
            this.connection.setCharsetName("utf8");
        }
        if (this.isLogin()) {
            return true;
        }
        switch (this.authorisationConfig.getType()) {
            case PASSWORD: {
                String pass = this.authorisationConfig.getPassword();
                boolean allHosts = this.authorisationConfig.isAllhosts();
                this.connection.login(pass, allHosts);
                break;
            }
            case TICKET: {
                String ticket = this.authorisationConfig.getTicketValue();
                this.connection.setAuthTicket(ticket);
                break;
            }
            case TICKETPATH: {
                String path = this.authorisationConfig.getTicketPath();
                if (path == null || path.isEmpty()) {
                    path = this.connection.getTicketsFilePath();
                }
                this.connection.setTicketsFilePath(path);
                break;
            }
            default: {
                throw new Exception("Unknown Authorisation type: " + (Object)((Object)this.authorisationConfig.getType()));
            }
        }
        if (this.isLogin()) {
            return true;
        }
        String status = this.connection.getLoginStatus();
        logger.info("P4: login failed '" + status + "'");
        return false;
    }

    public void logout() throws Exception {
        if (this.isLogin()) {
            this.connection.logout();
        }
    }

    private boolean isLogin() throws Exception {
        List resultMaps = this.connection.execMapCmdList(CmdSpec.LOGIN, new String[]{"-s"}, null);
        if (ObjectUtils.nonNull((Object)resultMaps) && !resultMaps.isEmpty()) {
            for (Map map : resultMaps) {
                String status = ResultMapParser.getInfoStr((Map)map);
                if (status == null) continue;
                if (status.contains("not necessary")) {
                    return true;
                }
                if (status.contains("ticket expires in")) {
                    return true;
                }
                if (!status.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public List<IFileSpec> getDirs(List<String> paths) throws Exception {
        paths = this.cleanDirPaths(paths);
        List spec = FileSpecBuilder.makeFileSpecList(paths);
        GetDirectoriesOptions opts = new GetDirectoriesOptions();
        List dirs = this.connection.getDirectories(spec, opts);
        if (this.validate.check((List<IFileSpec>)dirs, "")) {
            return dirs;
        }
        return new ArrayList<IFileSpec>();
    }

    private List<String> cleanDirPaths(List<String> paths) throws Exception {
        if (paths.contains("//...")) {
            return this.getDepotsForDirs();
        }
        ListIterator<String> list = paths.listIterator();
        while (list.hasNext()) {
            String i = list.next();
            if (i.endsWith("/...")) {
                i = i.substring(0, i.length() - "/...".length());
            }
            if (i.endsWith("/*")) continue;
            list.set(i + "/*");
        }
        return paths;
    }

    private List<String> getDepotsForDirs() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        List depots = this.connection.getDepots();
        for (IDepot depot : depots) {
            String name = depot.getName();
            paths.add("//" + name + "/*");
        }
        return paths;
    }

    public List<IStreamSummary> getStreams(List<String> paths) throws Exception {
        GetStreamsOptions opts = new GetStreamsOptions();
        List streams = this.connection.getStreams(paths, opts);
        return streams;
    }

    public IChangelistSummary getChangeSummary(long id) throws P4JavaException {
        List spec = FileSpecBuilder.makeFileSpecList((String[])new String[]{"@" + id});
        GetChangelistsOptions cngOpts = new GetChangelistsOptions();
        cngOpts.setLongDesc(true);
        cngOpts.setMaxMostRecent(1);
        List summary = this.connection.getChangelists(spec, cngOpts);
        if (summary.isEmpty()) {
            return null;
        }
        return (IChangelistSummary)summary.get(0);
    }

    public List<IFix> getJobs(int id) throws P4JavaException {
        GetFixesOptions opts = new GetFixesOptions();
        opts.setChangelistId(id);
        List fixes = this.connection.getFixes(null, opts);
        return fixes;
    }

    public boolean isCounter(String name) throws Exception {
        if (name.equals("now")) {
            return false;
        }
        try {
            CounterOptions opts = new CounterOptions();
            String counter = this.connection.getCounter(name, opts);
            return !"0".equals(counter);
        }
        catch (RequestException e) {
            return false;
        }
    }

    public String getCounter(String id) throws Exception {
        CounterOptions opts = new CounterOptions();
        String counter = this.connection.getCounter(id, opts);
        return counter;
    }

    public boolean isLabel(String name) throws Exception {
        if (name.equals("now")) {
            return false;
        }
        try {
            ILabel label = this.connection.getLabel(name);
            return label != null;
        }
        catch (RequestException e) {
            return false;
        }
    }

    public String labelToChange(String name) {
        try {
            Label label = this.getLabel(name);
            String spec = label.getRevisionSpec();
            if (spec != null && !spec.isEmpty()) {
                if (spec.startsWith("@")) {
                    spec = spec.substring(1);
                }
                return spec;
            }
            return name;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String counterToChange(String name) {
        try {
            String counter = this.getCounter(name);
            if (!"0".equals(counter)) {
                try {
                    int change = Integer.parseInt(counter);
                    return String.valueOf(change);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public boolean isClient(String name) throws Exception {
        try {
            if (name == null) {
                return false;
            }
            IClient client = this.connection.getClient(name);
            return client != null;
        }
        catch (RequestException e) {
            return false;
        }
    }

    public void deleteClient(String name) throws Exception {
        DeleteClientOptions opts = new DeleteClientOptions();
        this.connection.deleteClient(name, opts);
    }

    public String getEmail(String userName) throws Exception {
        IUser user = this.connection.getUser(userName);
        if (user != null) {
            String email = user.getEmail();
            return email;
        }
        return "";
    }

    public Label getLabel(String id) throws Exception {
        return (Label)this.connection.getLabel(id);
    }

    public void setLabel(Label label) throws Exception {
        String user = this.connection.getUserName();
        label.setOwnerName(user);
        this.connection.updateLabel((ILabel)label);
    }

    public List<IFileSpec> getLabelFiles(String id, int limit) throws Exception {
        String path = "//...@" + id;
        List spec = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        GetDepotFilesOptions opts = new GetDepotFilesOptions();
        opts.setMaxResults(limit);
        List tagged = this.connection.getDepotFiles(spec, opts);
        return tagged;
    }

    public List<IFileSpec> getChangeFiles(long id, int limit) throws Exception {
        List files = !this.checkVersion(20141) ? this.connection.getChangelistFiles((int)id) : this.connection.getChangelistFiles((int)id, limit);
        return files;
    }

    public List<IFileSpec> getShelvedFiles(int id) throws Exception {
        Map map;
        String cmd = CmdSpec.DESCRIBE.name();
        String[] args = new String[]{"-s", "-S", "" + id};
        List resultMaps = this.connection.execMapCmdList(cmd, args, null);
        ArrayList<IFileSpec> list = new ArrayList<IFileSpec>();
        if (resultMaps != null && resultMaps.size() > 0 && resultMaps.get(0) != null && (map = (Map)resultMaps.get(0)).containsKey("shelved")) {
            int i = 0;
            while (map.get("rev" + i) != null) {
                FileSpec fSpec = new FileSpec(map, (IServer)this.connection, i);
                fSpec.setChangelistId(id);
                list.add((IFileSpec)fSpec);
                ++i;
            }
        }
        return list;
    }

    public String getSwarm() throws P4JavaException {
        GetPropertyOptions propOpts = new GetPropertyOptions();
        String key = "P4.Swarm.URL";
        propOpts.setName(key);
        List values = this.connection.getProperty(propOpts);
        for (IProperty prop : values) {
            if (!key.equals(prop.getName())) continue;
            String url = prop.getValue();
            if (url != null && url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return url;
        }
        return null;
    }

    public long getHead(String path) throws Exception {
        logger.info("getHead: p4 changes " + path);
        List spec = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setMaxMostRecent(1);
        List changes = this.connection.getChangelists(spec, opts);
        if (!changes.isEmpty()) {
            return ((IChangelistSummary)changes.get(0)).getId();
        }
        return -1L;
    }

    public long getLowestHead(String path, String from, String to) throws Exception {
        String rev = path + "@" + from + ",@" + to;
        logger.info("getLowestHead: p4 changes " + rev);
        List spec = FileSpecBuilder.makeFileSpecList((String[])new String[]{rev});
        List changes = this.connection.getChangelists(spec, null);
        if (!changes.isEmpty()) {
            return ((IChangelistSummary)changes.get(changes.size() - 1)).getId();
        }
        return -1L;
    }

    public boolean hasFile(String depotPath) throws Exception {
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{depotPath});
        GetDepotFilesOptions opts = new GetDepotFilesOptions(new String[]{"-e"});
        List specs = this.connection.getDepotFiles(files, opts);
        return this.validate.checkCatch(specs, "");
    }

    public ICommit getGraphCommit(String sha, String repo) throws P4JavaException {
        return this.connection.getCommitObject(sha, repo);
    }

    public List<IFileSpec> getCommitFiles(String repo, String sha) throws P4JavaException {
        return this.connection.getCommitFiles(repo, sha);
    }

    public P4Ref getGraphHead(String repo) {
        GraphCommitLogOptions opts = new GraphCommitLogOptions();
        opts.setMaxResults(1);
        opts.setRepo(repo);
        List list = null;
        try {
            list = this.connection.getGraphCommitLogList(opts);
        }
        catch (P4JavaException e) {
            this.log("P4: no commits under " + repo + " using HEAD.");
            return new P4LabelRef("HEAD");
        }
        if (!list.isEmpty() && list.get(0) != null) {
            ICommit commit = (ICommit)list.get(0);
            return new P4GraphRef(repo, commit);
        }
        this.log("P4: commit log empty for " + repo + " using HEAD.");
        return new P4LabelRef("HEAD");
    }

    public List<P4Ref> listCommits(List<P4Ref> fromRefs, P4Ref to) throws Exception {
        ArrayList<P4Ref> list = new ArrayList<P4Ref>();
        if (!(to instanceof P4GraphRef)) {
            return list;
        }
        P4GraphRef toGraph = (P4GraphRef)to;
        for (P4Ref from : fromRefs) {
            P4GraphRef fromGraph;
            if (!(from instanceof P4GraphRef) || !(fromGraph = (P4GraphRef)from).getRepo().equals(toGraph.getRepo()) || fromGraph.getSha().equals(toGraph.getSha())) continue;
            GraphCommitLogOptions opts = new GraphCommitLogOptions();
            String repo = fromGraph.getRepo();
            opts.setRepo(repo);
            String range = fromGraph.getSha() + ".." + toGraph.getSha();
            opts.setCommitValue(new String[]{range});
            opts.setMaxResults(this.getMaxChangeLimit());
            List logList = this.connection.getGraphCommitLogList(opts);
            for (ICommit log : logList) {
                P4GraphRef ref = new P4GraphRef(repo, log);
                list.add(ref);
            }
        }
        return list;
    }

    public List<IRepo> listAllRepos() throws Exception {
        List repos = this.connection.getRepos();
        return repos;
    }

    public List<IRepo> listRepos(String path) throws Exception {
        ReposOptions opts = new ReposOptions();
        opts.setNameFilter(path);
        List repos = this.connection.getRepos(opts);
        return repos;
    }

    protected void disconnect() {
        try {
            this.connection.disconnect();
            logger.fine("P4: closed connection OK");
        }
        catch (Exception e) {
            String err = "P4: Unable to close Perforce connection.";
            logger.severe(err);
            this.log(err);
        }
    }

    @Deprecated
    public static P4BaseCredentials findCredential(String id) {
        Class<P4BaseCredentials> type = P4BaseCredentials.class;
        Jenkins scope = Jenkins.getInstance();
        Authentication acl = ACL.SYSTEM;
        DomainRequirement domain = new DomainRequirement();
        List list = CredentialsProvider.lookupCredentials(type, (ItemGroup)scope, (Authentication)acl, (DomainRequirement[])new DomainRequirement[]{domain});
        for (P4BaseCredentials c : list) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public static P4BaseCredentials findCredential(String credentialsId, ItemGroup context) {
        if (credentialsId == null) {
            return null;
        }
        P4BaseCredentials credentials = (P4BaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(P4BaseCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(P4BaseCredentials.class)}));
        return credentials;
    }

    public static P4BaseCredentials findCredential(String credentialsId, Item item) {
        if (credentialsId == null) {
            return null;
        }
        if (item == null) {
            return ConnectionHelper.findCredential(credentialsId);
        }
        P4BaseCredentials credentials = (P4BaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(P4BaseCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(P4BaseCredentials.class)}));
        return credentials;
    }

    public static P4BaseCredentials findCredential(String credentialsId, Run run) {
        if (credentialsId == null) {
            return null;
        }
        P4BaseCredentials credentials = (P4BaseCredentials)CredentialsProvider.findCredentialById((String)credentialsId, P4BaseCredentials.class, (Run)run, Collections.emptyList());
        return credentials;
    }

    protected int getMaxChangeLimit() {
        PerforceScm.DescriptorImpl scm = this.getP4SCM();
        int max = 0;
        if (scm != null) {
            max = scm.getMaxChanges();
        }
        max = max > 0 ? max : 20;
        return max;
    }

    public long getHeadLimit() {
        PerforceScm.DescriptorImpl scm = this.getP4SCM();
        if (scm != null) {
            return scm.getHeadLimit();
        }
        return 0L;
    }

    public PerforceScm.DescriptorImpl getP4SCM() {
        Descriptor dsc;
        Jenkins j = Jenkins.getInstance();
        if (j != null && (dsc = j.getDescriptor(PerforceScm.class)) instanceof PerforceScm.DescriptorImpl) {
            PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)dsc;
            return p4scm;
        }
        return null;
    }

    public void log(String msg) {
        if (this.listener == null) {
            return;
        }
        this.listener.getLogger().println(msg);
    }

    public boolean hasAborted() {
        return this.abort;
    }

    public void abort() {
        this.abort = true;
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }
}

