/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import java.io.Serializable;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;

public class ConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String p4port;
    private final boolean ssl;
    private final String serverUri;
    private final String trust;
    private final int timeout;
    private final String p4host;

    public ConnectionConfig(P4BaseCredentials credential) {
        this.p4port = credential.getP4port();
        this.ssl = credential.isSsl();
        this.trust = credential.getTrust();
        this.serverUri = credential.getP4JavaUri();
        this.timeout = credential.getTimeout();
        this.p4host = credential.getP4host();
    }

    public String getPort() {
        return this.p4port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getTrust() {
        return this.trust;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getP4Host() {
        return this.p4host;
    }

    public String toString() {
        return this.serverUri;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionConfig) {
            ConnectionConfig comp = (ConnectionConfig)obj;
            return this.toString().equals(comp.toString());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 1777 * hash + this.toString().hashCode();
        return hash;
    }
}

