/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.graph.ICommit;
import com.perforce.p4java.impl.generic.core.Label;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4GraphRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.email.P4UserProperty;
import org.kohsuke.stapler.export.Exported;

public class P4ChangeEntry
extends ChangeLogSet.Entry {
    private static Logger logger = Logger.getLogger(P4ChangeEntry.class.getName());
    private int fileCountLimit = 50;
    private P4Ref id;
    private User author;
    private Date date = new Date();
    private String clientId = "";
    private String msg = "";
    private List<P4AffectedFile> affectedFiles;
    private boolean shelved;
    private boolean fileLimit = false;
    private List<IFix> jobs;

    public P4ChangeEntry(P4ChangeSet parent) {
        this.setParent(parent);
        this.jobs = new ArrayList<IFix>();
        this.affectedFiles = new ArrayList<P4AffectedFile>();
        this.getFileCountLimit();
    }

    public P4ChangeEntry() {
        this.getFileCountLimit();
    }

    public void setChange(ConnectionHelper p4, IChangelistSummary changelist) throws Exception {
        List<IFileSpec> files;
        int changeId = changelist.getId();
        this.id = new P4ChangeRef(changeId);
        String user = changelist.getUsername();
        this.author = User.get((String)user);
        String email = p4.getEmail(user);
        if (email != null && !email.isEmpty()) {
            P4UserProperty p4prop = new P4UserProperty(email);
            this.author.addProperty((UserProperty)p4prop);
            logger.fine("Setting email for user: " + user + ":" + email);
            Mailer.UserProperty prop = (Mailer.UserProperty)this.author.getProperty(Mailer.UserProperty.class);
            if (prop == null || prop.getAddress() == null || prop.getAddress().isEmpty()) {
                prop = new Mailer.UserProperty(email);
                this.author.addProperty((UserProperty)prop);
                logger.fine("Setting default user: " + user + ":" + email);
            }
        }
        this.date = changelist.getDate();
        this.clientId = changelist.getClientId();
        this.msg = changelist.getDescription();
        if (changelist.getStatus() == ChangelistStatus.PENDING) {
            files = p4.getShelvedFiles(changeId);
            this.shelved = true;
        } else {
            files = p4.getChangeFiles(changeId, this.fileCountLimit + 1);
            this.shelved = false;
        }
        if (files != null && files.size() > this.fileCountLimit) {
            this.fileLimit = true;
            files = files.subList(0, this.fileCountLimit);
        }
        this.affectedFiles = new ArrayList<P4AffectedFile>();
        if (files != null) {
            for (IFileSpec item : files) {
                this.affectedFiles.add(new P4AffectedFile(item));
            }
        }
        this.jobs = p4.getJobs(changeId);
    }

    public void setLabel(ConnectionHelper p4, String labelId) throws Exception {
        Label label = p4.getLabel(labelId);
        this.id = new P4LabelRef(labelId);
        String user = label.getOwnerName();
        user = user != null && !user.isEmpty() ? user : "unknown";
        this.author = User.get((String)user);
        this.date = label.getLastAccess();
        this.clientId = labelId;
        this.msg = label.getDescription();
        List<IFileSpec> files = p4.getLabelFiles(labelId, this.fileCountLimit + 1);
        if (files.size() > this.fileCountLimit) {
            this.fileLimit = true;
            files = files.subList(0, this.fileCountLimit);
        }
        this.affectedFiles = new ArrayList<P4AffectedFile>();
        for (IFileSpec item : files) {
            this.affectedFiles.add(new P4AffectedFile(item));
        }
    }

    public void setGraphCommit(ConnectionHelper p4, String id) throws Exception {
        if (id == null || id.isEmpty() || !id.contains("@")) {
            return;
        }
        String[] parts = id.split("@");
        if (parts.length != 2) {
            return;
        }
        String repo = parts[0];
        String sha = parts[1];
        this.setGraphCommit(p4, repo, sha);
    }

    public void setGraphCommit(ConnectionHelper p4, String repo, String sha) throws Exception {
        ICommit commit = p4.getGraphCommit(sha, repo);
        this.id = new P4GraphRef(repo, commit);
        String user = commit.getAuthor();
        user = user != null && !user.isEmpty() ? user : "unknown";
        this.author = User.get((String)user);
        this.date = commit.getDate();
        this.clientId = commit.getAuthorEmail();
        this.msg = commit.getDescription();
        this.affectedFiles = new ArrayList<P4AffectedFile>();
        List<IFileSpec> graphFiles = p4.getCommitFiles(repo, sha);
        for (IFileSpec item : graphFiles) {
            String path = item.getDepotPathString();
            FileAction action = item.getAction();
            this.affectedFiles.add(new P4AffectedFile(path, sha, action));
        }
        if (this.affectedFiles.size() > this.fileCountLimit) {
            this.fileLimit = true;
            this.affectedFiles = this.affectedFiles.subList(0, this.fileCountLimit);
        }
    }

    @Exported
    public String getChangeNumber() {
        return this.id.toString();
    }

    @Exported
    public String getChangeTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(this.date);
    }

    public P4Ref getId() {
        return this.id;
    }

    public void setId(P4Ref value) {
        this.id = value;
    }

    public User getAuthor() {
        if (this.author == null) {
            return User.getUnknown();
        }
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = User.get((String)value);
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            this.date = sdf.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMsg() {
        return this.msg;
    }

    public int getRows() {
        String[] lines = this.msg.split("\r\n|\r|\n");
        int rows = lines.length;
        rows = rows > 10 ? 10 : rows;
        return rows;
    }

    public void setMsg(String value) {
        this.msg = value;
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> affectedPaths = new ArrayList<String>();
        for (P4AffectedFile item : this.getAffectedFiles()) {
            affectedPaths.add(item.getPath());
        }
        return affectedPaths;
    }

    public Collection<P4AffectedFile> getAffectedFiles() {
        return this.affectedFiles;
    }

    public void addAffectedFiles(P4AffectedFile file) {
        this.affectedFiles.add(file);
    }

    public boolean isFileLimit() {
        return this.fileLimit;
    }

    public String getAction(IFileSpec file) {
        FileAction action = file.getAction();
        String s = action.name();
        return s.replace("/", "_");
    }

    public void setShelved(boolean value) {
        this.shelved = value;
    }

    public boolean isShelved() {
        return this.shelved;
    }

    public boolean isLabel() {
        return this.id.isLabel();
    }

    public List<IFix> getJobs() {
        return this.jobs;
    }

    public void addJob(IFix job) {
        this.jobs.add(job);
    }

    public String getJobStatus(IFix job) {
        String status = job.getStatus();
        return status;
    }

    public int getMaxLimit() {
        return this.fileCountLimit;
    }

    @Exported
    public long getTimestamp() {
        return this.getDate().getTime();
    }

    @Exported
    public String getCommitId() {
        return this.getChangeNumber();
    }

    private int getFileCountLimit() {
        Descriptor dsc;
        int max = 0;
        Jenkins j = Jenkins.getInstance();
        if (j != null && (dsc = j.getDescriptor(PerforceScm.class)) instanceof PerforceScm.DescriptorImpl) {
            PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)dsc;
            max = p4scm.getMaxFiles();
        }
        this.fileCountLimit = max > 0 ? max : 50;
        return this.fileCountLimit;
    }
}

