/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.osfbuildersuite.xmllinter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLinterBuilder
extends Builder
implements SimpleBuildStep {
    private String xsdsPath;
    private String xmlsPath;
    private String reportPath;

    @DataBoundConstructor
    public XMLLinterBuilder(String xsdsPath, String xmlsPath, String reportPath) {
        this.xsdsPath = xsdsPath;
        this.xmlsPath = xmlsPath;
        this.reportPath = reportPath;
    }

    public String getXsdsPath() {
        return this.xsdsPath;
    }

    @DataBoundSetter
    public void setXsdsPath(String xsdsPath) {
        this.xsdsPath = xsdsPath;
    }

    public String getXmlsPath() {
        return this.xmlsPath;
    }

    @DataBoundSetter
    public void setXmlsPath(String xmlsPath) {
        this.xmlsPath = xmlsPath;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    @DataBoundSetter
    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println();
        logger.println(String.format("--[B: %s]--", this.getDescriptor().getDisplayName()));
        workspace.act((FilePath.FileCallable)new XMLLinterCallable(workspace, listener, this.xsdsPath, this.xmlsPath, this.reportPath));
        logger.println(String.format("--[E: %s]--", this.getDescriptor().getDisplayName()));
        logger.println();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class XMLLinterCallable
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final FilePath workspace;
        private final TaskListener listener;
        private final String xsdsPath;
        private final String xmlsPath;
        private final String reportPath;

        public XMLLinterCallable(FilePath workspace, TaskListener listener, String xsdsPath, String xmlsPath, String reportPath) {
            this.workspace = workspace;
            this.listener = listener;
            this.xsdsPath = xsdsPath;
            this.xmlsPath = xmlsPath;
            this.reportPath = reportPath;
        }

        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            PrintStream logger = this.listener.getLogger();
            if (StringUtils.isEmpty((CharSequence)this.xsdsPath)) {
                throw new AbortException("Missing value for \"XSDs Path\"!");
            }
            File xsdsDir = new File(dir, this.xsdsPath);
            if (!xsdsDir.toPath().normalize().startsWith(dir.toPath())) {
                throw new AbortException("Invalid value for \"XSDs Path\"! The path needs to be inside the workspace!");
            }
            if (!xsdsDir.exists()) {
                throw new AbortException(String.format("\"%s\" does not exist!", this.xsdsPath));
            }
            if (!xsdsDir.isDirectory()) {
                throw new AbortException(String.format("\"%s\" is not a directory!", this.xsdsPath));
            }
            if (StringUtils.isEmpty((CharSequence)this.xmlsPath)) {
                throw new AbortException("Missing value for \"XMLs Path\"!");
            }
            File xmlsDir = new File(dir, this.xmlsPath);
            if (!xmlsDir.toPath().normalize().startsWith(dir.toPath())) {
                throw new AbortException("Invalid value for \"XMLs Path\"! The path needs to be inside the workspace!");
            }
            if (!xmlsDir.exists()) {
                throw new AbortException(String.format("\"%s\" does not exist!", this.xmlsPath));
            }
            if (!xmlsDir.isDirectory()) {
                throw new AbortException(String.format("\"%s\" is not a directory!", this.xmlsPath));
            }
            JsonArray errors = new JsonArray();
            logger.println(String.format("[+] Loading XSD files from %s", this.xsdsPath));
            HashMap xsdsMap = new HashMap();
            Files.walk(xsdsDir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".xsd")).forEach(path -> {
                String relativePath = dir.toPath().relativize((Path)path).toString();
                try {
                    Document xsdDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(path.toFile());
                    String targetNamespace = xsdDoc.getDocumentElement().getAttribute("targetNamespace");
                    if (StringUtils.isNotEmpty((CharSequence)targetNamespace)) {
                        xsdsMap.put(targetNamespace, path.toFile());
                        logger.println(String.format("    ~ Loaded %s", relativePath));
                    } else {
                        logger.println(String.format("    ~ Skipping %s. Missing \"targetNamespace\" attribute", relativePath));
                    }
                }
                catch (SAXParseException e) {
                    logger.println(String.format("    ~ ERROR parsing %s@%s:%s", relativePath, e.getLineNumber(), e.getColumnNumber()));
                    logger.println(String.format("      Message = %s", e.getMessage()));
                    JsonObject error = new JsonObject();
                    error.addProperty("path", relativePath);
                    error.addProperty("start_line", (Number)e.getLineNumber());
                    error.addProperty("end_line", (Number)e.getLineNumber());
                    error.addProperty("annotation_level", "failure");
                    error.addProperty("message", e.getMessage());
                    errors.add((JsonElement)error);
                }
                catch (SAXException e) {
                    logger.println(String.format("    ~ ERROR parsing %s", relativePath));
                    logger.println(String.format("      Message = %s", e.getMessage()));
                    JsonObject error = new JsonObject();
                    error.addProperty("path", relativePath);
                    error.addProperty("start_line", (Number)0);
                    error.addProperty("end_line", (Number)0);
                    error.addProperty("annotation_level", "failure");
                    error.addProperty("message", e.getMessage());
                    errors.add((JsonElement)error);
                }
                catch (IOException e) {
                    logger.println(String.format("    ~ ERROR loading %s", relativePath));
                }
                catch (ParserConfigurationException e) {
                    logger.println(String.format("    ~ ERROR creating a new instance of a DocumentBuilder for %s", relativePath));
                }
            });
            logger.println(" + Done");
            logger.println();
            logger.println(String.format("[+] Linting XML files from %s", this.xmlsPath));
            Files.walk(xmlsDir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".xml")).forEach(path -> {
                String relativePath = dir.toPath().relativize((Path)path).toString();
                try {
                    Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(path.toFile());
                    String xmlNs = xmlDoc.getDocumentElement().getAttribute("xmlns");
                    if (StringUtils.isNotEmpty((CharSequence)xmlNs)) {
                        File xsdFile = (File)xsdsMap.get(xmlNs);
                        if (xsdFile != null) {
                            SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(xsdFile)).newValidator().validate(new StreamSource(path.toFile()));
                            logger.println(String.format("    ~ Linted %s", relativePath));
                        } else {
                            logger.println(String.format("    ~ Skipping %s. No matching \"XSD\" found", relativePath));
                        }
                    } else {
                        logger.println(String.format("    ~ Skipping %s. Missing \"xmlns\" attribute", relativePath));
                    }
                }
                catch (SAXParseException e) {
                    logger.println(String.format("    ~ ERROR parsing %s@%s:%s", relativePath, e.getLineNumber(), e.getColumnNumber()));
                    logger.println(String.format("      Message = %s", e.getMessage()));
                    JsonObject error = new JsonObject();
                    error.addProperty("path", relativePath);
                    error.addProperty("start_line", (Number)e.getLineNumber());
                    error.addProperty("end_line", (Number)e.getLineNumber());
                    error.addProperty("annotation_level", "failure");
                    error.addProperty("message", e.getMessage());
                    errors.add((JsonElement)error);
                }
                catch (SAXException e) {
                    logger.println(String.format("    ~ ERROR parsing %s", relativePath));
                    logger.println(String.format("      Message = %s", e.getMessage()));
                    JsonObject error = new JsonObject();
                    error.addProperty("path", relativePath);
                    error.addProperty("start_line", (Number)0);
                    error.addProperty("end_line", (Number)0);
                    error.addProperty("annotation_level", "failure");
                    error.addProperty("message", e.getMessage());
                    errors.add((JsonElement)error);
                }
                catch (IOException e) {
                    logger.println(String.format("    ~ ERROR loading %s", relativePath));
                }
                catch (ParserConfigurationException e) {
                    logger.println(String.format("    ~ ERROR creating a new instance of a DocumentBuilder for %s", relativePath));
                }
            });
            logger.println(" + Done");
            logger.println();
            if (!StringUtils.isEmpty((CharSequence)this.reportPath)) {
                File reportDir = new File(dir, this.reportPath);
                if (!reportDir.toPath().normalize().startsWith(dir.toPath())) {
                    throw new AbortException("Invalid value for \"Report Path\"! The path needs to be inside the workspace!");
                }
                if (!reportDir.exists() && !reportDir.mkdirs()) {
                    throw new AbortException(String.format("Failed to create %s!", reportDir.getAbsolutePath()));
                }
                String randomUUID = UUID.randomUUID().toString();
                File reportFile = new File(reportDir, String.format("XMLLint.%s.json", randomUUID));
                if (reportFile.exists()) {
                    throw new AbortException(String.format("reportFile=%s already exists!", reportFile.getAbsolutePath()));
                }
                OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8");
                streamWriter.write(errors.toString());
                ((Writer)streamWriter).close();
            }
            if (errors.size() > 0) {
                throw new AbortException("XMLLint FAILED!");
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"osfBuilderSuiteXMLLint"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "OSF Builder Suite :: XML Linter";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

