/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.ssh;

import com.oracle.cloud.compute.jenkins.JenkinsUtil;
import com.oracle.cloud.compute.jenkins.ssh.SshConnector;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class SshComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(SshComputerLauncher.class.getName());
    private static final int RETRY_TIMES = 1;
    private final String host;
    private final int connectTimeoutMillis;
    private final String privateKey;
    private final String initScript;
    private final String remoteAdmin;
    private final int initScriptTimeoutSeconds;

    public SshComputerLauncher(String host, int connectTimeoutMillis, String privateKey, String initScript, int initScriptTimeoutSeconds, String remoteAdmin) {
        this.host = host;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.privateKey = privateKey;
        this.initScript = initScript;
        this.initScriptTimeoutSeconds = initScriptTimeoutSeconds;
        this.remoteAdmin = remoteAdmin;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        String remoteFS;
        LOGGER.info("Launch agent on host: " + this.host);
        Connection retryConn = null;
        PrintStream logger = listener.getLogger();
        SshConnector sshConnector = SshConnector.INSTANCE;
        int i = 0;
        while (true) {
            retryConn = sshConnector.createConnection(this.host);
            try {
                sshConnector.connect(retryConn, this.connectTimeoutMillis);
            }
            catch (Exception e) {
                retryConn.close();
                if (i++ == 1) {
                    throw new IOException("SSH launch failed at connecting to host: " + this.host, e);
                }
                LOGGER.log(Level.FINER, "Ignoring connection exception when executing ssh launch on host: " + this.host, e);
                continue;
            }
            break;
        }
        final Connection conn = retryConn;
        i = 0;
        while (true) {
            try {
                while (!conn.authenticateWithPublicKey(this.remoteAdmin, this.privateKey.toCharArray(), null)) {
                }
            }
            catch (IOException e) {
                if (i++ == 1) {
                    conn.close();
                    throw new IOException("SSH launch failed at authenticating to host: " + this.host, e);
                }
                LOGGER.log(Level.FINER, "Ignoring connection exception when authenticating with public key during ssh launch on host: " + this.host, e);
                continue;
            }
            break;
        }
        SCPClient scp = conn.createSCPClient();
        Slave agent = computer.getNode();
        String string = remoteFS = agent == null ? null : agent.getRemoteFS();
        if (remoteFS == null || remoteFS.trim().isEmpty()) {
            remoteFS = ".";
        }
        conn.exec("mkdir -p " + remoteFS, (OutputStream)logger);
        if (this.initScript != null && this.initScript.trim().length() > 0 && conn.exec("test -e ~/.hudson-run-init", (OutputStream)logger) != 0) {
            scp.put(this.initScript.getBytes("UTF-8"), "init.sh", remoteFS, "0700");
            Session sess = conn.openSession();
            sess.requestDumbPTY();
            sess.execCommand("/bin/bash " + remoteFS + "/init.sh");
            sess.getStdin().close();
            sess.getStderr().close();
            IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
            int exitStatus = this.waitCompletion(sess);
            if (exitStatus != 0) {
                LOGGER.warning("init script failed: exit code=" + exitStatus);
                return;
            }
            sess.close();
            sess = conn.openSession();
            sess.requestDumbPTY();
            sess.execCommand("/bin/bash touch ~/.hudson-run-init");
            sess.close();
        }
        scp.put(JenkinsUtil.getJenkinsInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", remoteFS);
        String launchString = "java -jar " + remoteFS + "/slave.jar";
        LOGGER.info("Launching slave agent (via Trilead SSH2 Connection): " + launchString);
        final Session sess = conn.openSession();
        sess.execCommand(launchString);
        computer.setChannel(sess.getStdout(), sess.getStdin(), (OutputStream)logger, new Channel.Listener(){

            public void onClosed(Channel channel, IOException cause) {
                sess.close();
                conn.close();
            }
        });
    }

    private int waitCompletion(Session session) throws InterruptedException {
        LOGGER.info("Timeout around for init script complete is " + this.initScriptTimeoutSeconds);
        for (int i = 0; i < this.initScriptTimeoutSeconds; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return -1;
    }
}

