/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.client;

import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientUnauthorizedException;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudInstanceOrchestrationConfig;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudObjectName;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudUser;
import com.oracle.cloud.compute.jenkins.model.ImageList;
import com.oracle.cloud.compute.jenkins.model.ImageListEntry;
import com.oracle.cloud.compute.jenkins.model.ImageListSourceType;
import com.oracle.cloud.compute.jenkins.model.InstanceOrchestration;
import com.oracle.cloud.compute.jenkins.model.SSHKey;
import com.oracle.cloud.compute.jenkins.model.SecurityList;
import com.oracle.cloud.compute.jenkins.model.Shape;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class JaxrsComputeCloudClient
implements ComputeCloudClient {
    private static final Logger LOGGER = Logger.getLogger(JaxrsComputeCloudClient.class.getName());
    static final MediaType ORACLE_COMPUTE_V3_MEDIA_TYPE = new MediaType("application", "oracle-compute-v3+json");
    private static final JsonProvider JSON_PROVIDER = JsonProvider.provider();
    static final String AUTHENTICATE_COOKIE_NAME = "nimbula";
    private final URI apiEndpoint;
    private final ComputeCloudUser user;
    private final String password;
    private final Client client;
    private volatile Collection<NewCookie> authenticationCookies;
    static final String IP_RESERVATION_LABEL = "ip-reservation";
    static final String STORAGE_VOLUME_LABEL = "storage-volume";
    static final String LAUNCHPLAN_LABEL = "launchplan";

    public JaxrsComputeCloudClient(URI apiEndpoint, ComputeCloudUser user, String password, Client client) {
        this.apiEndpoint = apiEndpoint;
        this.user = user;
        this.password = password;
        this.client = client;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.apiEndpoint + ", " + this.user + ", #" + this.password.hashCode() + ']';
    }

    @Override
    public void close() {
        this.client.close();
    }

    private UriBuilder newUriBuilder() {
        return UriBuilder.fromUri((URI)this.apiEndpoint);
    }

    private UriBuilder newUriBuilder(String path) {
        return this.newUriBuilder().path(path);
    }

    static JsonObjectBuilder createObjectBuilder() {
        return JSON_PROVIDER.createObjectBuilder();
    }

    static JsonArrayBuilder createArrayBuilder() {
        return JSON_PROVIDER.createArrayBuilder();
    }

    static <T extends JsonStructure> Entity<T> entity(T json) {
        return Entity.entity(json, (MediaType)ORACLE_COMPUTE_V3_MEDIA_TYPE);
    }

    <T> T readEntity(Response response, Class<T> entityType) {
        return (T)response.readEntity(entityType);
    }

    private Response invoke(Invocation inv) throws ComputeCloudClientException {
        Response response;
        try {
            response = inv.invoke();
        }
        catch (ProcessingException e) {
            String message = e.getMessage();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof JsonException)) continue;
                Throwable jsonCause = cause.getCause();
                if (jsonCause == null) break;
                message = jsonCause.getMessage();
                break;
            }
            throw new ComputeCloudClientException(message, e);
        }
        Response.StatusType statusInfo = response.getStatusInfo();
        if (statusInfo.getFamily() != Response.Status.Family.SUCCESSFUL) {
            StringBuilder messageBuilder = new StringBuilder().append("HTTP ").append(statusInfo.getStatusCode()).append(' ').append(statusInfo.getReasonPhrase());
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)response.getMediaType())) {
                try {
                    JsonObject entity = this.readEntity(response, JsonObject.class);
                    String message = entity.getString("message");
                    messageBuilder.append(": ").append(message);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error reading error message", e);
                }
            }
            String message = messageBuilder.toString();
            if (Response.Status.fromStatusCode((int)statusInfo.getStatusCode()) == Response.Status.UNAUTHORIZED) {
                throw new ComputeCloudClientUnauthorizedException(message);
            }
            throw new ComputeCloudClientException(message);
        }
        return response;
    }

    @Override
    public void authenticate() throws ComputeCloudClientException {
        Invocation inv = this.client.target(this.newUriBuilder("authenticate/")).request().buildPost(JaxrsComputeCloudClient.entity(JaxrsComputeCloudClient.createObjectBuilder().add("user", this.user.getString()).add("password", this.password).build()));
        this.authenticationCookies = this.invoke(inv).getCookies().values();
    }

    private Invocation.Builder addAuthenticationCookies(Invocation.Builder builder) {
        if (this.authenticationCookies == null) {
            throw new IllegalStateException("Not authenticated");
        }
        for (Cookie cookie : this.authenticationCookies) {
            if (cookie.getName() == null || !cookie.getName().equalsIgnoreCase(AUTHENTICATE_COOKIE_NAME)) continue;
            builder.cookie(cookie.getName(), cookie.getValue());
        }
        return builder;
    }

    private Invocation.Builder request(UriBuilder uriBuilder) {
        return this.addAuthenticationCookies(this.client.target(uriBuilder).request());
    }

    private Invocation.Builder request(String path) {
        return this.request(this.newUriBuilder(path));
    }

    private JsonObject invokeAndReadJsonObject(Invocation inv) throws ComputeCloudClientException {
        return this.readEntity(this.invoke(inv), JsonObject.class);
    }

    private JsonArray invokeAndGetResultArray(Invocation inv) throws ComputeCloudClientException {
        return this.invokeAndReadJsonObject(inv).getJsonArray("result");
    }

    private static Boolean getBoolean(JsonObject o, String key) {
        Boolean b = o.containsKey((Object)key) ? Boolean.valueOf(o.getBoolean(key)) : null;
        return b;
    }

    private static Long getLong(JsonObject o, String key) {
        JsonNumber n = o.getJsonNumber(key);
        return n == null ? null : Long.valueOf(n.longValueExact());
    }

    private static Integer getInteger(JsonObject o, String key) {
        JsonNumber n = o.getJsonNumber(key);
        return n == null ? null : Integer.valueOf(n.intValueExact());
    }

    private static BigDecimal getBigDecimal(JsonObject o, String key) {
        JsonNumber n = o.getJsonNumber(key);
        return n == null ? null : n.bigDecimalValue();
    }

    private static String getString(JsonObject o, String key) {
        return o.getString(key, null);
    }

    private static List<String> toStringList(JsonArray arr) {
        ArrayList<String> result = new ArrayList<String>(arr.size());
        for (JsonString stringJson : arr.getValuesAs(JsonString.class)) {
            result.add(stringJson.getString());
        }
        return result;
    }

    private static List<String> getStringList(JsonObject o, String key) {
        JsonArray arr = o.getJsonArray(key);
        return arr == null ? null : JaxrsComputeCloudClient.toStringList(arr);
    }

    private static List<ImageListEntry> toImageListEntryList(JsonObject o, String key) throws ComputeCloudClientException {
        final JsonArray arr = o.getJsonArray(key);
        return new ArrayList<ImageListEntry>(){
            {
                for (JsonObject entryJson : arr.getValuesAs(JsonObject.class)) {
                    this.add(JaxrsComputeCloudClient.toImageListEntry(entryJson));
                }
            }
        };
    }

    @Override
    public Collection<Shape> getShapes() throws ComputeCloudClientException {
        ArrayList<Shape> result = new ArrayList<Shape>();
        Invocation inv = this.request("shape/").accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        for (JsonObject shapeJson : this.invokeAndGetResultArray(inv).getValuesAs(JsonObject.class)) {
            result.add(this.toShape(shapeJson));
        }
        return result;
    }

    private Shape toShape(JsonObject shapeJson) throws ComputeCloudClientException {
        return new Shape().cpus(JaxrsComputeCloudClient.getBigDecimal(shapeJson, "cpus")).gpus(JaxrsComputeCloudClient.getLong(shapeJson, "gpus")).io(JaxrsComputeCloudClient.getLong(shapeJson, "io")).isRootSsd(JaxrsComputeCloudClient.getBoolean(shapeJson, "is_root_ssd")).name(JaxrsComputeCloudClient.getString(shapeJson, "name")).ndsIopsLimit(JaxrsComputeCloudClient.getLong(shapeJson, "nds_iops_limit")).placementRequirements(JaxrsComputeCloudClient.getStringList(shapeJson, "placement_requirements")).ram(JaxrsComputeCloudClient.getLong(shapeJson, "ram")).rootDiskSize(JaxrsComputeCloudClient.getLong(shapeJson, "root_disk_size")).ssdDataSize(JaxrsComputeCloudClient.getLong(shapeJson, "ssd_data_size")).uri(JaxrsComputeCloudClient.getString(shapeJson, "uri"));
    }

    @Override
    public Collection<SecurityList> getSecurityLists() throws ComputeCloudClientException {
        ArrayList<SecurityList> result = new ArrayList<SecurityList>();
        Invocation inv = this.request("seclist" + this.user.getString() + '/').accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        for (JsonObject securityJson : this.invokeAndGetResultArray(inv).getValuesAs(JsonObject.class)) {
            result.add(this.toSecurityList(securityJson));
        }
        return result;
    }

    private SecurityList toSecurityList(JsonObject securityJson) throws ComputeCloudClientException {
        return new SecurityList().account(JaxrsComputeCloudClient.getString(securityJson, "account")).description(JaxrsComputeCloudClient.getString(securityJson, "description")).uri(JaxrsComputeCloudClient.getString(securityJson, "uri")).outboundCidrPolicy(JaxrsComputeCloudClient.getString(securityJson, "outbound_cidr_policy")).policy(JaxrsComputeCloudClient.getString(securityJson, "policy")).groupId(JaxrsComputeCloudClient.getString(securityJson, "group_id")).id(JaxrsComputeCloudClient.getString(securityJson, "id")).name(JaxrsComputeCloudClient.getString(securityJson, "name"));
    }

    private SSHKey toSSHKey(JsonObject sshKeyJson) throws ComputeCloudClientException {
        return new SSHKey().enabled(JaxrsComputeCloudClient.getBoolean(sshKeyJson, "enabled")).uri(JaxrsComputeCloudClient.getString(sshKeyJson, "uri")).key(JaxrsComputeCloudClient.getString(sshKeyJson, "key")).name(JaxrsComputeCloudClient.getString(sshKeyJson, "name"));
    }

    @Override
    public Collection<SSHKey> getSSHKeys() throws ComputeCloudClientException {
        ArrayList<SSHKey> result = new ArrayList<SSHKey>();
        Invocation inv = this.request("sshkey" + this.user.getString() + '/').accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        for (JsonObject sshkey : this.invokeAndGetResultArray(inv).getValuesAs(JsonObject.class)) {
            result.add(this.toSSHKey(sshkey));
        }
        return result;
    }

    @Override
    public SSHKey getSSHKey(String name) throws ComputeCloudClientException {
        Invocation inv = this.request("sshkey" + this.user.getString() + '/' + name).accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        return this.toSSHKey(this.invokeAndReadJsonObject(inv));
    }

    private static ImageListEntry toImageListEntry(JsonObject imageListEntryJson) throws ComputeCloudClientException {
        return new ImageListEntry().attributes(imageListEntryJson.get((Object)"attributes")).machineimages(JaxrsComputeCloudClient.getStringList(imageListEntryJson, "machineimages")).uri(JaxrsComputeCloudClient.getString(imageListEntryJson, "uri")).version(JaxrsComputeCloudClient.getInteger(imageListEntryJson, "version"));
    }

    private ImageList toImageList(JsonObject imageListJson) throws ComputeCloudClientException {
        return new ImageList()._default(JaxrsComputeCloudClient.getInteger(imageListJson, "default")).description(JaxrsComputeCloudClient.getString(imageListJson, "description")).name(JaxrsComputeCloudClient.getString(imageListJson, "name")).uri(JaxrsComputeCloudClient.getString(imageListJson, "uri"));
    }

    @Override
    public Collection<ImageList> getImageLists(ImageListSourceType sourceType) throws ComputeCloudClientException {
        ArrayList<ImageList> result = new ArrayList<ImageList>();
        String uri = "imagelist";
        uri = sourceType.equals((Object)ImageListSourceType.ORACLE_PUBLIC_IMAGE) ? uri + "/oracle/public/" : uri + this.user.getString() + '/';
        Invocation inv = this.request(uri).accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        for (JsonObject imageListJson : this.invokeAndGetResultArray(inv).getValuesAs(JsonObject.class)) {
            result.add(this.toImageList(imageListJson));
        }
        return result;
    }

    @Override
    public Collection<ImageListEntry> getImageListEntries(String imageListName) throws ComputeCloudClientException {
        ArrayList<ImageListEntry> result = new ArrayList<ImageListEntry>();
        String uri = "imagelist" + imageListName;
        Invocation inv = this.request(uri).accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet();
        for (ImageListEntry imageListEntry : JaxrsComputeCloudClient.toImageListEntryList(this.invokeAndReadJsonObject(inv), "entries")) {
            result.add(imageListEntry);
        }
        return result;
    }

    private static JsonObject createDependsRelationshipJson(String from, String to) {
        return JaxrsComputeCloudClient.createObjectBuilder().add("oplan", from).add("to_oplan", to).add("type", "depends").build();
    }

    private String getAttributeNameString(ComputeCloudObjectName attributeName) {
        return attributeName.getString();
    }

    private JsonObject buildSingleInstanceJsonObject(ComputeCloudObjectName objectName, ComputeCloudInstanceOrchestrationConfig params) {
        ComputeCloudObjectName instanceName = objectName;
        String volumeNameString = this.getAttributeNameString(objectName);
        String ipReservationNameString = this.getAttributeNameString(objectName);
        String shapeName = params.getShapeName();
        String sshKeyName = params.getSshKeyName();
        JsonArrayBuilder securityListNamesJson = JaxrsComputeCloudClient.createArrayBuilder();
        for (String securityName : params.getSecurityListNames()) {
            securityListNamesJson.add(securityName);
        }
        JsonObjectBuilder instanceObjBuilder = JaxrsComputeCloudClient.createObjectBuilder().add("shape", shapeName == null ? "" : shapeName).add("name", instanceName.getString()).add("storage_attachments", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("index", 1).add("volume", volumeNameString).build()).build()).add("networking", (JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("eth0", (JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("seclists", securityListNamesJson).add("nat", "ipreservation:" + ipReservationNameString).build()).build()).add("boot_order", JaxrsComputeCloudClient.createArrayBuilder().add(1)).add("sshkeys", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add(sshKeyName == null ? "" : sshKeyName).build());
        if (params.isHypervisorPvEnabled()) {
            instanceObjBuilder.add("hypervisor", JaxrsComputeCloudClient.createObjectBuilder().add("mode", "pv"));
        }
        return instanceObjBuilder.build();
    }

    @Override
    public void createInstanceOrchestration(String name, ComputeCloudInstanceOrchestrationConfig params) throws ComputeCloudClientException {
        ComputeCloudObjectName objectName = ComputeCloudObjectName.valueOf(this.user, name);
        String volumeNameString = this.getAttributeNameString(objectName);
        String ipReservationNameString = this.getAttributeNameString(objectName);
        String description = params.getOrchDescriptionValue();
        String imageListName = params.getImageListName();
        String imageListEntry = params.getImageListEntry();
        String volumeSize = params.getVolumeSizeValue();
        JsonObject instanceJsonObject = this.buildSingleInstanceJsonObject(objectName, params);
        Invocation inv = this.request("orchestration/").accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildPost(JaxrsComputeCloudClient.entity(JaxrsComputeCloudClient.createObjectBuilder().add("name", objectName.getString()).add("description", description).add("oplans", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("label", IP_RESERVATION_LABEL).add("obj_type", "ip/reservation").add("objects", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("name", ipReservationNameString).add("parentpool", "/oracle/public/ippool").add("permanent", true).build()).build()).build()).add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("label", STORAGE_VOLUME_LABEL).add("obj_type", "storage/volume").add("objects", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("name", volumeNameString).add("bootable", true).add("imagelist", imageListName == null ? "" : imageListName).add("imagelist_entry", imageListEntry == null ? "" : imageListEntry).add("size", volumeSize == null ? "" : volumeSize).add("properties", JaxrsComputeCloudClient.createArrayBuilder().add("/oracle/public/storage/default")).build()).build()).build()).add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("label", LAUNCHPLAN_LABEL).add("obj_type", LAUNCHPLAN_LABEL).add("ha_policy", "active").add("objects", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createObjectBuilder().add("instances", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)instanceJsonObject).build()).build()).build()).build()).build()).add("relationships", (JsonValue)JaxrsComputeCloudClient.createArrayBuilder().add((JsonValue)JaxrsComputeCloudClient.createDependsRelationshipJson(LAUNCHPLAN_LABEL, IP_RESERVATION_LABEL)).add((JsonValue)JaxrsComputeCloudClient.createDependsRelationshipJson(LAUNCHPLAN_LABEL, STORAGE_VOLUME_LABEL)).build()).build()));
        this.invokeAndReadJsonObject(inv);
    }

    private UriBuilder newOrchestrationUriBuilder(String name) {
        return this.newUriBuilder().path("orchestration" + ComputeCloudObjectName.valueOf(this.user, name).getString());
    }

    private JsonObject findOplanObjectJson(JsonArray oplansJson, String label) throws ComputeCloudClientException {
        for (JsonObject oplanJson : oplansJson.getValuesAs(JsonObject.class)) {
            if (!oplanJson.getString("label").equals(label)) continue;
            JsonArray objects = oplanJson.getJsonArray("objects");
            if (objects.size() != 1) {
                throw new ComputeCloudClientException("expected 1 object for the " + label + " oplan, found " + objects.size());
            }
            return objects.getJsonObject(0);
        }
        throw new ComputeCloudClientException("oplan not found: " + label);
    }

    private List<String> findErrorObjectsJson(JsonArray oplansJson) throws ComputeCloudClientException {
        ArrayList<String> errors = new ArrayList<String>();
        for (JsonObject oplanJson : oplansJson.getValuesAs(JsonObject.class)) {
            if (oplanJson.getString("status") == null || !oplanJson.getString("status").equals(InstanceOrchestration.Status.error.toString()) || oplanJson.getJsonObject("info") == null) continue;
            String opanLabel = oplanJson.getString("label");
            JsonObject infoObject = oplanJson.getJsonObject("info");
            if (infoObject.getJsonObject("errors") == null) {
                errors.add(opanLabel + " in error status with unknown error!");
                continue;
            }
            for (JsonValue errorVal : infoObject.getJsonObject("errors").values()) {
                errors.add("<------ OPlan " + opanLabel + " in error status with message: " + errorVal.toString() + "------>");
            }
        }
        return errors;
    }

    @Override
    public InstanceOrchestration getInstanceOrchestration(String name) throws ComputeCloudClientException {
        JsonObject orchJson = this.invokeAndReadJsonObject(this.request(this.newOrchestrationUriBuilder(name)).accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildGet());
        JsonArray oplansJson = orchJson.getJsonArray("oplans");
        JsonObject ipReservationJson = this.findOplanObjectJson(oplansJson, IP_RESERVATION_LABEL);
        InstanceOrchestration instanceOrch = new InstanceOrchestration().status(InstanceOrchestration.Status.valueOf(orchJson.getString("status"))).ip(ipReservationJson.getString("ip", null));
        if (orchJson.getString("status") != null && orchJson.getString("status").equals(InstanceOrchestration.Status.error.toString())) {
            List<String> errors = this.findErrorObjectsJson(oplansJson);
            instanceOrch = instanceOrch.errors(errors);
        }
        return instanceOrch;
    }

    private void updateOrchestrationState(String name, String action) throws ComputeCloudClientException {
        UriBuilder uriBuilder = this.newOrchestrationUriBuilder(name).queryParam("action", new Object[]{action});
        this.invokeAndReadJsonObject(this.request(uriBuilder).accept(new MediaType[]{ORACLE_COMPUTE_V3_MEDIA_TYPE}).buildPut(JaxrsComputeCloudClient.entity(JaxrsComputeCloudClient.createObjectBuilder().build())));
    }

    @Override
    public void startOrchestration(String name) throws ComputeCloudClientException {
        this.updateOrchestrationState(name, "START");
    }

    @Override
    public void stopOrchestration(String name) throws ComputeCloudClientException {
        this.updateOrchestrationState(name, "STOP");
    }

    @Override
    public void deleteOrchestration(String name) throws ComputeCloudClientException {
        this.invoke(this.request(this.newOrchestrationUriBuilder(name)).buildDelete());
    }
}

