/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.client;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ComputeCloudUser {
    private static final String IDENTITY_DOMAIN_PREFIX = "Compute-";
    private static final Pattern IDENTITY_DOMAIN_NAME_PATTERN = Pattern.compile("[^/]+");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("[^/]+");
    private static final Pattern PATTERN = Pattern.compile("/(Compute-(" + IDENTITY_DOMAIN_NAME_PATTERN + "))/(" + USERNAME_PATTERN + ")");
    private static final String ORACLE_FULL_IDENTITY_DOMAIN_NAME = "oracle";
    private static final String ORACLE_PUBLIC_USERNAME = "public";
    public static final ComputeCloudUser ORACLE_PUBLIC = new ComputeCloudUser(ComputeCloudUser.createString("oracle", "public"), "oracle", null, "public");
    private final String string;
    private final String fullIdentityDomainName;
    private final String identityDomainName;
    private final String username;

    private static String createString(String fullIdentityDomainName, String username) {
        return '/' + fullIdentityDomainName + '/' + username;
    }

    public static ComputeCloudUser parse(String user) {
        if (user.equals(ORACLE_PUBLIC.getString())) {
            return ORACLE_PUBLIC;
        }
        Matcher matcher = PATTERN.matcher(Objects.requireNonNull(user, "user"));
        if (!matcher.matches()) {
            throw new IllegalArgumentException(user);
        }
        return new ComputeCloudUser(user, matcher.group(1), matcher.group(2), matcher.group(3));
    }

    public static ComputeCloudUser valueOf(String identityDomainName, String username) {
        if (!IDENTITY_DOMAIN_NAME_PATTERN.matcher(identityDomainName).matches()) {
            throw new IllegalArgumentException("identityDomainName");
        }
        if (!USERNAME_PATTERN.matcher(username).matches()) {
            throw new IllegalArgumentException("username");
        }
        String fullIdentityDomainName = IDENTITY_DOMAIN_PREFIX + identityDomainName;
        String string = ComputeCloudUser.createString(fullIdentityDomainName, username);
        return new ComputeCloudUser(string, fullIdentityDomainName, identityDomainName, username);
    }

    private ComputeCloudUser(String string, String fullIdentityDomainName, String identityDomainName, String username) {
        this.string = string;
        this.fullIdentityDomainName = fullIdentityDomainName;
        this.identityDomainName = identityDomainName;
        this.username = username;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.string + ']';
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ComputeCloudUser u = (ComputeCloudUser)o;
        return this.string.equals(u.string);
    }

    public String getString() {
        return this.string;
    }

    public String getFullIdentityDomainName() {
        return this.fullIdentityDomainName;
    }

    public String getIdentityDomainName() {
        return this.identityDomainName;
    }

    public String getUsername() {
        return this.username;
    }
}

