/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.client;

import com.oracle.cloud.compute.jenkins.client.ComputeCloudUser;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComputeCloudObjectName {
    private static final Pattern NAME_PATTERN = Pattern.compile(".+");
    private static final Pattern PATTERN = Pattern.compile("(/[^/]+/[^/]+)/(" + NAME_PATTERN + ")");
    private final String string;
    private final ComputeCloudUser user;
    private final String name;

    public static ComputeCloudObjectName parse(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        ComputeCloudUser user = ComputeCloudUser.parse(matcher.group(1));
        String name = matcher.group(2);
        return new ComputeCloudObjectName(string, user, name);
    }

    public static ComputeCloudObjectName valueOf(ComputeCloudUser user, String name) {
        Objects.requireNonNull(user, "user");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("name");
        }
        String string = user.getString() + '/' + name;
        return new ComputeCloudObjectName(string, user, name);
    }

    private ComputeCloudObjectName(String string, ComputeCloudUser user, String name) {
        this.string = string;
        this.user = user;
        this.name = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.string + ']';
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ComputeCloudObjectName n = (ComputeCloudObjectName)o;
        return this.string.equals(n.string);
    }

    public String getString() {
        return this.string;
    }

    public ComputeCloudUser getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }
}

