/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.client;

import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.client.ProxyComputeCloudClient;
import com.oracle.cloud.compute.jenkins.model.ImageList;
import com.oracle.cloud.compute.jenkins.model.ImageListSourceType;
import com.oracle.cloud.compute.jenkins.model.Shape;
import java.util.Collection;

public class CachingComputeCloudClient
extends ProxyComputeCloudClient {
    private Collection<Shape> shapes;
    private Collection<ImageList> oraclePublicImageLists;
    private Collection<ImageList> customerPrivateImageLists;

    public CachingComputeCloudClient(ComputeCloudClient client) {
        super(client);
    }

    private synchronized void clearCaches() {
        this.shapes = null;
        this.oraclePublicImageLists = null;
        this.customerPrivateImageLists = null;
    }

    @Override
    public void authenticate() throws ComputeCloudClientException {
        this.clearCaches();
        super.authenticate();
    }

    @Override
    public synchronized Collection<Shape> getShapes() throws ComputeCloudClientException {
        Collection<Shape> shapes = this.shapes;
        if (shapes == null) {
            this.shapes = shapes = super.getShapes();
        }
        return shapes;
    }

    @Override
    public synchronized Collection<ImageList> getImageLists(ImageListSourceType sourceType) throws ComputeCloudClientException {
        Collection<ImageList> imageLists = null;
        if (sourceType.equals((Object)ImageListSourceType.ORACLE_PUBLIC_IMAGE)) {
            imageLists = this.oraclePublicImageLists;
        } else if (sourceType.equals((Object)ImageListSourceType.PRIVATE_IAMGE)) {
            imageLists = this.customerPrivateImageLists;
        }
        if (imageLists == null) {
            imageLists = super.getImageLists(sourceType);
            if (sourceType.equals((Object)ImageListSourceType.ORACLE_PUBLIC_IMAGE)) {
                this.oraclePublicImageLists = imageLists;
            } else if (sourceType.equals((Object)ImageListSourceType.PRIVATE_IAMGE)) {
                this.customerPrivateImageLists = imageLists;
            }
        }
        return imageLists;
    }
}

