/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins.client;

import com.oracle.cloud.compute.jenkins.Clock;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.client.ProxyComputeCloudClient;
import java.util.concurrent.TimeUnit;

public class AutoAuthComputeCloudClient
extends ProxyComputeCloudClient {
    static final long AUTHENTICATION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(30L);
    static final long REAUTHENTICATE_SLACK_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private final Clock clock;
    private boolean authenticated;
    private long authenticatedNanoTime;

    public AutoAuthComputeCloudClient(ComputeCloudClient client) {
        this(client, Clock.INSTANCE);
    }

    public AutoAuthComputeCloudClient(ComputeCloudClient client, Clock clock) {
        super(client);
        this.clock = clock;
    }

    @Override
    public void close() {
        this.client.close();
    }

    private synchronized void authenticate(long nanoTime) throws ComputeCloudClientException {
        this.client.authenticate();
        this.authenticated = true;
        this.authenticatedNanoTime = nanoTime;
    }

    @Override
    public void authenticate() throws ComputeCloudClientException {
        this.authenticate(this.clock.nanoTime());
    }

    @Override
    protected synchronized void preInvoke() throws ComputeCloudClientException {
        long nanoTime = this.clock.nanoTime();
        if (this.authenticated && nanoTime - this.authenticatedNanoTime < AUTHENTICATION_TIMEOUT_NANOS - REAUTHENTICATE_SLACK_NANOS) {
            return;
        }
        this.authenticate(nanoTime);
    }
}

