/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.Clock;

public class TimeoutHelper {
    private final Clock clock;
    private final long beginNanos;
    private final long timeoutNanos;
    private final long sleepMillis;

    public TimeoutHelper(Clock clock, long timeoutNanos, long sleepMillis) {
        this.clock = clock;
        this.beginNanos = clock.nanoTime();
        this.timeoutNanos = timeoutNanos;
        this.sleepMillis = sleepMillis;
    }

    public boolean sleep() throws InterruptedException {
        long durationNanos;
        if (this.timeoutNanos != 0L && (durationNanos = this.clock.nanoTime() - this.beginNanos) >= this.timeoutNanos) {
            return false;
        }
        this.clock.sleep(this.sleepMillis);
        return true;
    }
}

