/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;

public class SshKeyUtil {
    private static final String SSH_RSA_ALGORITHM_NAME = "ssh-rsa";

    public static String toSshString(RSAPublicKey key) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SshKeyUtil.write(out, SSH_RSA_ALGORITHM_NAME.getBytes(StandardCharsets.UTF_8));
            SshKeyUtil.write(out, key.getPublicExponent().toByteArray());
            SshKeyUtil.write(out, key.getModulus().toByteArray());
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return "ssh-rsa " + Base64.encodeBase64String((byte[])out.toByteArray());
    }

    private static void write(ByteArrayOutputStream out, byte[] b) throws IOException {
        SshKeyUtil.writeMpint(out, b.length);
        out.write(b);
    }

    private static void writeMpint(OutputStream out, int value) throws IOException {
        out.write(value >> 24 & 0xFF);
        out.write(value >> 16 & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value & 0xFF);
    }
}

