/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.Messages;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;

public class JenkinsUtil {
    public static <T extends Describable<T>> Descriptor<T> getDescriptorOrDie(Class<? extends T> type) {
        Descriptor desc = JenkinsUtil.getJenkinsInstance().getDescriptorOrDie(type);
        if (!desc.isSubTypeOf(type)) {
            throw new IllegalStateException(type.toString());
        }
        return desc;
    }

    public static <S extends Describable<S>, T extends S, D extends Descriptor<S>> D getDescriptorOrDie(Class<T> type, Class<D> descriptorType) {
        return (D)((Descriptor)descriptorType.cast(JenkinsUtil.getJenkinsInstance().getDescriptorOrDie(type)));
    }

    public static FormValidation validateRequired(String value) {
        if (Util.fixEmptyAndTrim((String)value) == null) {
            return FormValidation.error((String)Messages.FormValidation_ValidateRequired());
        }
        return FormValidation.ok();
    }

    public static String unescape(String s) {
        return new Unescaper(s).unescape();
    }

    public static Jenkins getJenkinsInstance() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Fail to get Jenkins instance, which means it has not been started, or was already shut down");
        }
        return jenkins;
    }

    private static class Unescaper {
        private final String string;
        private int pos;
        private final StringBuilder builder;

        Unescaper(String string) {
            this.string = string;
            this.builder = new StringBuilder(string.length());
        }

        String unescape() {
            while (this.pos < this.string.length()) {
                if (this.unescape("<br>", '\n') || this.unescape("&lt;", '<') || this.unescape("&gt;", '>') || this.unescape("&amp;", '&') || this.unescape("&quot;", '\"') || this.unescape("&#039;", '\'') || this.unescape("&nbsp;", ' ')) continue;
                this.builder.append(this.string.charAt(this.pos));
                ++this.pos;
            }
            return this.builder.toString();
        }

        private boolean unescape(String from, char to) {
            if (this.pos + from.length() <= this.string.length() && this.string.regionMatches(this.pos, from, 0, from.length())) {
                this.builder.append(to);
                this.pos += from.length();
                return true;
            }
            return false;
        }
    }
}

