/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.ComputeCloudAgent;
import com.oracle.cloud.compute.jenkins.JenkinsUtil;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class ComputeCloudInstanceMonitor
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(ComputeCloudInstanceMonitor.class.getName());
    private static final Long recurrencePeriod = TimeUnit.MINUTES.toMillis(10L);

    public ComputeCloudInstanceMonitor() {
        super("Oracle Cloud Infrastructure Compute Classic instances monitor");
        LOGGER.log(Level.FINE, "Oracle Cloud Infrastructure Compute Classic check alive period is {0}ms", recurrencePeriod);
    }

    public long getRecurrencePeriod() {
        return recurrencePeriod;
    }

    List<Node> getNodes() {
        return JenkinsUtil.getJenkinsInstance().getNodes();
    }

    protected void execute(TaskListener listener) {
        for (Node node : this.getNodes()) {
            if (!(node instanceof ComputeCloudAgent)) continue;
            ComputeCloudAgent agent = (ComputeCloudAgent)node;
            try {
                if (!agent.isAlive()) {
                    LOGGER.fine("Compute instance is offline: " + agent.getDisplayName());
                    agent._terminate(listener);
                    LOGGER.info("Compute instance is terminated: " + agent.getDisplayName());
                    this.removeNode(agent);
                    continue;
                }
                LOGGER.fine("Compute instance is online: " + agent.getDisplayName());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to terminate node : " + agent.getDisplayName(), e);
                this.removeNode(agent);
            }
        }
    }

    void removeNode(ComputeCloudAgent agent) {
        try {
            JenkinsUtil.getJenkinsInstance().removeNode((Node)agent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to remove node: " + agent.getDisplayName());
        }
    }
}

