/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.ComputeCloud;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientFactory;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudUser;
import com.oracle.cloud.compute.jenkins.client.ProxyComputeCloudClient;
import hudson.slaves.Cloud;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class ComputeCloudClientManager
implements AutoCloseable,
ComputeCloudClientFactory {
    private final ComputeCloudClientFactory factory;
    private final Collection<Cloud> activeClouds;
    private final Map<ClientKey, ClientData> clients = new LinkedHashMap<ClientKey, ClientData>();

    public ComputeCloudClientManager(ComputeCloudClientFactory factory, Collection<Cloud> activeClouds) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.activeClouds = Objects.requireNonNull(activeClouds, "activeClouds");
    }

    public String toString() {
        return super.toString() + '[' + this.factory + ", " + this.clients + ']';
    }

    @Override
    public synchronized void close() {
        for (ClientData clientData : this.clients.values()) {
            clientData.client.close();
        }
        this.clients.clear();
    }

    private static ClientKey createKey(ComputeCloud cloud) {
        return new ClientKey(cloud.getApiEndpointUrl(), cloud.getUser(), cloud.getPassword());
    }

    private void removeUnusedClients() {
        HashSet<ClientKey> used = new HashSet<ClientKey>();
        for (Cloud cloud : this.activeClouds) {
            if (!(cloud instanceof ComputeCloud)) continue;
            ComputeCloud computeCloud = (ComputeCloud)cloud;
            try {
                used.add(ComputeCloudClientManager.createKey(computeCloud));
            }
            catch (IllegalStateException illegalStateException) {}
        }
        Iterator<Map.Entry<ClientKey, ClientData>> iter = this.clients.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ClientKey, ClientData> entry = iter.next();
            if (used.contains(entry.getKey())) continue;
            iter.remove();
            entry.getValue().removeReference();
        }
    }

    private synchronized ComputeCloudClient createClient(ClientKey key) {
        ClientData clientData = this.clients.get(key);
        if (clientData == null) {
            this.removeUnusedClients();
            clientData = new ClientData(this.factory.createClient(key.apiEndpoint, key.user, key.password));
            this.clients.put(key, clientData);
        }
        return new ManagedComputeCloudClient(clientData);
    }

    public ComputeCloudClient createClient(ComputeCloud cloud) {
        return this.createClient(ComputeCloudClientManager.createKey(cloud));
    }

    @Override
    public ComputeCloudClient createClient(URI apiEndpoint, ComputeCloudUser user, String password) {
        return this.createClient(new ClientKey(apiEndpoint, user, password));
    }

    private static class ManagedComputeCloudClient
    extends ProxyComputeCloudClient {
        private final ClientData clientData;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ManagedComputeCloudClient(ClientData clientData) {
            super(clientData.client);
            this.clientData = clientData;
            clientData.addReference();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.clientData.removeReference();
            }
        }
    }

    private static class ClientData {
        final ComputeCloudClient client;
        private int numReferences = 1;

        public ClientData(ComputeCloudClient client) {
            this.client = client;
        }

        synchronized void addReference() {
            ++this.numReferences;
        }

        synchronized void removeReference() {
            --this.numReferences;
            if (this.numReferences == 0) {
                this.client.close();
            }
        }
    }

    static class ClientKey {
        final URI apiEndpoint;
        final ComputeCloudUser user;
        final String password;

        ClientKey(URI apiEndpoint, ComputeCloudUser user, String password) {
            this.apiEndpoint = apiEndpoint;
            this.user = user;
            this.password = password;
        }

        public String toString() {
            return super.toString() + '[' + this.apiEndpoint + ", " + this.user + ", #" + Integer.toHexString(this.password.hashCode()) + ']';
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.apiEndpoint.hashCode();
            result = 31 * result + this.user.hashCode();
            result = 31 * result + this.password.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ClientKey k = (ClientKey)o;
            return this.apiEndpoint.equals(k.apiEndpoint) && this.user.equals(k.user) && this.password.equals(k.password);
        }
    }
}

