/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.ComputeCloud;
import com.oracle.cloud.compute.jenkins.ComputeCloudAgent;
import com.oracle.cloud.compute.jenkins.DynamicResourceBundleHolder;
import com.oracle.cloud.compute.jenkins.FormFillFailure;
import com.oracle.cloud.compute.jenkins.FormValidationValue;
import com.oracle.cloud.compute.jenkins.JenkinsUtil;
import com.oracle.cloud.compute.jenkins.Messages;
import com.oracle.cloud.compute.jenkins.SshKeyUtil;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudInstanceOrchestrationConfig;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudObjectName;
import com.oracle.cloud.compute.jenkins.model.ImageList;
import com.oracle.cloud.compute.jenkins.model.ImageListEntry;
import com.oracle.cloud.compute.jenkins.model.ImageListSourceType;
import com.oracle.cloud.compute.jenkins.model.SSHKey;
import com.oracle.cloud.compute.jenkins.model.SecurityList;
import com.oracle.cloud.compute.jenkins.model.Shape;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.bouncycastle.api.PEMEncodable;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ComputeCloudAgentTemplate
implements Describable<ComputeCloudAgentTemplate>,
ComputeCloudInstanceOrchestrationConfig {
    private static final Logger LOGGER = Logger.getLogger(ComputeCloudAgentTemplate.class.getName());
    private static final Pattern VOLUME_SIZE_PATTERN = Pattern.compile("([0-9]+)([bB]|[kKmMgGtT][bB]?)?");
    private static final String DEFAULT_SSH_USER = "opc";
    static final int FAILURE_COUNT_LIMIT = 3;
    private final String description;
    private final String labelString;
    private transient Collection<LabelAtom> labelAtoms;
    private final Node.Mode mode;
    private final String initScript;
    private final String numExecutors;
    private final String idleTerminationMinutes;
    private final int templateId;
    private final String orchDescription;
    private final String shapeName;
    private final List<String> securityListNames;
    private final ImageListSourceType imageListSource;
    private final String imageListName;
    private final String imageListEntry;
    private final boolean hypervisorPVEnabled;
    private final String volumeSize;
    private final String remoteFS;
    private final String sshUser;
    private final String sshConnectTimeoutSeconds;
    private final String sshKeyName;
    private final String privateKey;
    private final String startTimeoutSeconds;
    private final String initScriptTimeoutSeconds;
    private transient int failureCount;
    private transient String disableCause;

    private static FormValidationValue<String> checkVolumeSize(String value) {
        FormValidation fv = JenkinsUtil.validateRequired(value);
        if (fv.kind != FormValidation.Kind.OK) {
            return FormValidationValue.error(fv);
        }
        Matcher matcher = VOLUME_SIZE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_volumeSize_invalid());
        }
        String size = matcher.group(1);
        String unit = matcher.group(2);
        if (unit == null) {
            unit = "G";
        } else if (unit.length() == 2) {
            unit = unit.substring(0, 1);
        }
        return FormValidationValue.ok(size + unit);
    }

    @DataBoundConstructor
    public ComputeCloudAgentTemplate(String description, String numExecutors, Node.Mode mode, String labelString, String idleTerminationMinutes, int templateId, String orchDescription, String shapeName, List<String> securityListNames, String imageListSource, String imageListName, String imageListEntry, boolean hypervisorPVEnabled, String volumeSize, String remoteFS, String sshUser, String sshConnectTimeoutSeconds, String sshKeyName, String privateKey, String initScript, String startTimeoutSeconds, String initScriptTimeoutSeconds) {
        this.description = description;
        this.numExecutors = numExecutors;
        this.mode = mode;
        this.labelString = labelString;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.templateId = templateId;
        this.orchDescription = orchDescription;
        this.shapeName = FormFillFailure.getErrorValue(shapeName);
        this.securityListNames = securityListNames == null || securityListNames.isEmpty() ? Collections.emptyList() : securityListNames;
        this.imageListSource = ImageListSourceType.fromValue(imageListSource);
        this.imageListName = FormFillFailure.getErrorValue(imageListName);
        this.imageListEntry = imageListEntry;
        this.hypervisorPVEnabled = hypervisorPVEnabled;
        this.volumeSize = volumeSize;
        this.remoteFS = remoteFS;
        this.sshUser = sshUser;
        this.sshConnectTimeoutSeconds = sshConnectTimeoutSeconds;
        this.sshKeyName = FormFillFailure.getErrorValue(sshKeyName);
        this.privateKey = privateKey;
        this.initScript = initScript;
        this.startTimeoutSeconds = startTimeoutSeconds;
        this.initScriptTimeoutSeconds = initScriptTimeoutSeconds;
    }

    public String getDisplayName() {
        return String.valueOf(this.getDescription());
    }

    public String getDescription() {
        return this.description;
    }

    public String getNumExecutors() {
        return this.numExecutors;
    }

    private static FormValidationValue<Integer> checkNumExecutors(String value) {
        return FormValidationValue.validatePositiveInteger(value, 1);
    }

    public int getNumExecutorsValue() {
        return ComputeCloudAgentTemplate.checkNumExecutors(this.numExecutors).getValue();
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getLabelString() {
        return this.labelString;
    }

    Collection<LabelAtom> parseLabels(String labels) {
        return Label.parse((String)labels);
    }

    public synchronized Collection<LabelAtom> getLabelAtoms() {
        Collection<LabelAtom> labelAtoms = this.labelAtoms;
        if (labelAtoms == null) {
            this.labelAtoms = labelAtoms = this.parseLabels(this.labelString);
        }
        return labelAtoms;
    }

    public String getIdleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public String getOrchDescription() {
        return this.orchDescription;
    }

    @Override
    public String getOrchDescriptionValue() {
        if (this.orchDescription == null || this.orchDescription.isEmpty()) {
            String result = Messages.ComputeCloudAgentTemplate_orchDescription_default();
            if (this.description != null && !this.description.isEmpty()) {
                result = result + ": " + this.description;
            }
            return result;
        }
        return this.orchDescription;
    }

    @Override
    public String getShapeName() {
        return this.shapeName;
    }

    public String getSecurityListName() {
        return this.securityListNames.isEmpty() ? null : this.securityListNames.get(0);
    }

    @Override
    public List<String> getSecurityListNames() {
        return this.securityListNames;
    }

    @Override
    public ImageListSourceType getImageListSource() {
        return this.imageListSource;
    }

    @Override
    public String getImageListName() {
        return this.imageListName;
    }

    @Override
    public String getImageListEntry() {
        return this.imageListEntry;
    }

    @Override
    public boolean isHypervisorPvEnabled() {
        return this.hypervisorPVEnabled;
    }

    public String getVolumeSize() {
        return this.volumeSize;
    }

    @Override
    public String getVolumeSizeValue() {
        FormValidationValue<String> valid = ComputeCloudAgentTemplate.checkVolumeSize(this.volumeSize);
        return valid.isOk() ? valid.getValue() : this.volumeSize;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public String getSshUserValue() {
        return this.sshUser == null || this.sshUser.trim().isEmpty() ? DEFAULT_SSH_USER : this.sshUser;
    }

    public String getSshConnectTimeoutSeconds() {
        return this.sshConnectTimeoutSeconds;
    }

    private static FormValidationValue<Integer> checkSshConnectTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, 30);
    }

    public int getSshConnectTimeoutMillis() {
        return (int)TimeUnit.SECONDS.toMillis(ComputeCloudAgentTemplate.checkSshConnectTimeoutSeconds(this.sshConnectTimeoutSeconds).getValue().intValue());
    }

    public int getInitScriptTimeoutSeconds() {
        return (int)TimeUnit.SECONDS.toSeconds(ComputeCloudAgentTemplate.checkInitScriptTimeoutSeconds(this.initScriptTimeoutSeconds).getValue().intValue());
    }

    private static FormValidationValue<Integer> checkInitScriptTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, 120);
    }

    @Override
    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getStartTimeoutSeconds() {
        return this.startTimeoutSeconds;
    }

    private static FormValidationValue<Integer> checkStartTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, (int)TimeUnit.MINUTES.toSeconds(5L));
    }

    public long getStartTimeoutNanos() {
        return TimeUnit.SECONDS.toNanos(ComputeCloudAgentTemplate.checkStartTimeoutSeconds(this.startTimeoutSeconds).getValue().intValue());
    }

    public synchronized void increaseFailureCount(String cause) {
        if (++this.failureCount >= 3) {
            LOGGER.warning("Agent template " + this.getDisplayName() + " disabled due to error: " + cause);
            this.disableCause = cause;
        }
    }

    public synchronized void resetFailureCount() {
        if (this.failureCount > 0) {
            this.failureCount = 0;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Agent template " + this.getDisplayName() + " is reset");
            }
        }
        if (this.disableCause != null) {
            this.disableCause = null;
            LOGGER.info("Agent template " + this.getDisplayName() + " is re-enabled");
        }
    }

    public synchronized String getDisableCause() {
        return this.disableCause;
    }

    public Descriptor<ComputeCloudAgentTemplate> getDescriptor() {
        return JenkinsUtil.getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputeCloudAgentTemplate> {
        private static final Comparator<Shape> SHAPE_COMPARATOR = new Comparator<Shape>(){

            @Override
            public int compare(Shape shape1, Shape shape2) {
                int diff = shape1.getCpus().compareTo(shape2.getCpus());
                if (diff == 0 && (diff = shape1.getRam().compareTo(shape2.getRam())) == 0 && (diff = shape1.getRootDiskSize().compareTo(shape2.getRootDiskSize())) == 0) {
                    shape1.getName().equals(shape2.getName());
                }
                return diff;
            }
        };
        private static final Comparator<SecurityList> SECURITY_LIST_COMPARATOR = new Comparator<SecurityList>(){

            @Override
            public int compare(SecurityList security1, SecurityList security2) {
                return security1.getName().compareTo(security2.getName());
            }
        };
        private static final Comparator<SSHKey> SSHKEY_COMPARATOR = new Comparator<SSHKey>(){

            @Override
            public int compare(SSHKey sshKey1, SSHKey sshKey2) {
                return sshKey1.getName().compareTo(sshKey2.getName());
            }
        };

        public String getHelpFile(String fieldName) {
            String p;
            if (fieldName.equals("privateKey")) {
                fieldName = "sshKeyName";
            }
            if ((p = super.getHelpFile(fieldName)) == null) {
                p = JenkinsUtil.getJenkinsInstance().getDescriptor(ComputeCloudAgent.class).getHelpFile(fieldName);
            }
            return p;
        }

        public static String getDefaultSshUser() {
            return ComputeCloudAgentTemplate.DEFAULT_SSH_USER;
        }

        public static int getDefaultNumExecutors() {
            return (Integer)ComputeCloudAgentTemplate.checkNumExecutors(null).getValue();
        }

        public FormValidation doCheckNumExecutors(@QueryParameter String value) {
            return ComputeCloudAgentTemplate.checkNumExecutors(value).getFormValidation();
        }

        ComputeCloud.DescriptorImpl getComputeCloudDescriptor() {
            return JenkinsUtil.getDescriptorOrDie(ComputeCloud.class, ComputeCloud.DescriptorImpl.class);
        }

        private ComputeCloudClient createClient(String apiEndpoint, String identityDomainName, String userName, String password) throws FormValidation {
            return this.getComputeCloudDescriptor().createClient(apiEndpoint, identityDomainName, userName, password);
        }

        private ComputeCloudClient createFormFillClient(String apiEndpoint, String identityDomainName, String userName, String password, String value) throws FormFillFailure {
            try {
                return this.createClient(apiEndpoint, identityDomainName, userName, password);
            }
            catch (FormValidation fv) {
                throw FormFillFailure.errorWithValue(fv, value);
            }
        }

        private static FormFillFailure toFormFillFailure(ComputeCloudClientException e, String value) {
            return FormFillFailure.errorWithValue(ComputeCloud.DescriptorImpl.toFormValidation(e), value);
        }

        public ListBoxModel doFillShapeNameItems(@QueryParameter @RelativePath(value="..") String apiEndpoint, @QueryParameter @RelativePath(value="..") String identityDomainName, @QueryParameter @RelativePath(value="..") String userName, @QueryParameter @RelativePath(value="..") String password, @QueryParameter String shapeName) throws FormFillFailure {
            shapeName = FormFillFailure.getErrorValue(shapeName);
            try (ComputeCloudClient client = this.createFormFillClient(apiEndpoint, identityDomainName, userName, password, shapeName);){
                ArrayList<Shape> shapes;
                try {
                    shapes = new ArrayList<Shape>(client.getShapes());
                }
                catch (ComputeCloudClientException e) {
                    throw DescriptorImpl.toFormFillFailure(e, shapeName);
                }
                ListBoxModel model = new ListBoxModel().add("");
                Collections.sort(shapes, SHAPE_COMPARATOR);
                for (Shape shape : shapes) {
                    String name = shape.getName();
                    BigDecimal cpus = shape.getCpus();
                    StringBuilder displayName = new StringBuilder().append(name).append(" - ").append(Messages.ComputeCloudAgentTemplate_shapeName_cpu(cpus, cpus.doubleValue())).append(", ").append(Messages.ComputeCloudAgentTemplate_shapeName_ram(FileUtils.byteCountToDisplaySize((long)(shape.getRam() * 0x100000L))));
                    long rootDiskSize = shape.getRootDiskSize();
                    if (rootDiskSize != 0L) {
                        displayName.append(", ").append(Messages.ComputeCloudAgentTemplate_shapeName_rootDiskSize(FileUtils.byteCountToDisplaySize((long)rootDiskSize)));
                    }
                    model.add((Object)new ListBoxModel.Option(displayName.toString(), name, name.equals(shapeName)));
                }
                ListBoxModel listBoxModel = model;
                return listBoxModel;
            }
        }

        public FormValidation doCheckShapeName(@QueryParameter String value) {
            return FormFillFailure.validateRequired(value);
        }

        public ListBoxModel doFillSecurityListNameItems(@QueryParameter @RelativePath(value="..") String apiEndpoint, @QueryParameter @RelativePath(value="..") String identityDomainName, @QueryParameter @RelativePath(value="..") String userName, @QueryParameter @RelativePath(value="..") String password, @QueryParameter String securityListName) throws FormFillFailure {
            securityListName = FormFillFailure.getErrorValue(securityListName);
            try (ComputeCloudClient client = this.createFormFillClient(apiEndpoint, identityDomainName, userName, password, securityListName);){
                ArrayList<SecurityList> securityLists;
                try {
                    securityLists = new ArrayList<SecurityList>(client.getSecurityLists());
                }
                catch (ComputeCloudClientException e) {
                    throw DescriptorImpl.toFormFillFailure(e, securityListName);
                }
                ListBoxModel model = new ListBoxModel().add("");
                Collections.sort(securityLists, SECURITY_LIST_COMPARATOR);
                for (SecurityList securityList : securityLists) {
                    String value = securityList.getName();
                    String displayName = ComputeCloudObjectName.parse(value).getName();
                    model.add((Object)new ListBoxModel.Option(displayName, value, value.equals(securityListName)));
                }
                ListBoxModel listBoxModel = model;
                return listBoxModel;
            }
        }

        public FormValidation doCheckSecurityListName(@QueryParameter String value) {
            return FormFillFailure.validateRequired(value);
        }

        public ListBoxModel doFillImageListSourceItems(@QueryParameter String imageListSource) {
            imageListSource = FormFillFailure.getErrorValue(imageListSource);
            ListBoxModel model = new ListBoxModel().add("");
            model.add((Object)new ListBoxModel.Option(ImageListSourceType.ORACLE_PUBLIC_IMAGE.toString(), ImageListSourceType.ORACLE_PUBLIC_IMAGE.toString(), imageListSource.equals(ImageListSourceType.ORACLE_PUBLIC_IMAGE.toString())));
            model.add((Object)new ListBoxModel.Option(ImageListSourceType.PRIVATE_IAMGE.toString(), ImageListSourceType.PRIVATE_IAMGE.toString(), imageListSource.equals(ImageListSourceType.PRIVATE_IAMGE.toString())));
            return model;
        }

        public ListBoxModel doFillImageListNameItems(@QueryParameter @RelativePath(value="..") String apiEndpoint, @QueryParameter @RelativePath(value="..") String identityDomainName, @QueryParameter @RelativePath(value="..") String userName, @QueryParameter @RelativePath(value="..") String password, @QueryParameter String imageListSource, @QueryParameter String imageListName) throws FormFillFailure {
            imageListName = FormFillFailure.getErrorValue(imageListName);
            ListBoxModel model = new ListBoxModel().add("");
            if (imageListSource == null || imageListSource.isEmpty()) {
                return model;
            }
            try (ComputeCloudClient client = this.createFormFillClient(apiEndpoint, identityDomainName, userName, password, imageListName);){
                ArrayList<ImageList> imageLists;
                try {
                    imageLists = new ArrayList<ImageList>(client.getImageLists(ImageListSourceType.fromValue(imageListSource)));
                }
                catch (ComputeCloudClientException e) {
                    throw DescriptorImpl.toFormFillFailure(e, imageListName);
                }
                for (ImageList imageList : imageLists) {
                    String value = imageList.getName();
                    String displayName = ComputeCloudObjectName.parse(value).getName();
                    model.add((Object)new ListBoxModel.Option(displayName, value, value.equals(imageListName)));
                }
                ListBoxModel listBoxModel = model;
                return listBoxModel;
            }
        }

        public ListBoxModel doFillImageListEntryItems(@QueryParameter @RelativePath(value="..") String apiEndpoint, @QueryParameter @RelativePath(value="..") String identityDomainName, @QueryParameter @RelativePath(value="..") String userName, @QueryParameter @RelativePath(value="..") String password, @QueryParameter String imageListName, @QueryParameter String imageListEntry) throws FormFillFailure {
            imageListEntry = FormFillFailure.getErrorValue(imageListEntry);
            ListBoxModel model = new ListBoxModel().add("");
            if (imageListName == null || imageListName.isEmpty()) {
                return model;
            }
            try (ComputeCloudClient client = this.createFormFillClient(apiEndpoint, identityDomainName, userName, password, imageListEntry);){
                ArrayList<ImageListEntry> imageListEntries;
                try {
                    imageListEntries = new ArrayList<ImageListEntry>(client.getImageListEntries(imageListName));
                }
                catch (ComputeCloudClientException e) {
                    throw DescriptorImpl.toFormFillFailure(e, imageListEntry);
                }
                for (ImageListEntry entry : imageListEntries) {
                    String value;
                    String displayName = value = entry.getVersion().toString();
                    model.add((Object)new ListBoxModel.Option(displayName, value, value.equals(imageListEntry)));
                }
                ListBoxModel listBoxModel = model;
                return listBoxModel;
            }
        }

        public FormValidation doCheckImageListSource(@QueryParameter String value) {
            return FormFillFailure.validateRequired(value);
        }

        public FormValidation doCheckImageListName(@QueryParameter String value) {
            return FormFillFailure.validateRequired(value);
        }

        public FormValidation doCheckVolumeSize(@QueryParameter String value) {
            return ComputeCloudAgentTemplate.checkVolumeSize(value).getFormValidation();
        }

        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)Messages.ComputeCloudAgentTemplate_labelString_exclusiveEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdleTerminationMinutes(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public static int getDefaultSshConnectTimeoutSeconds() {
            return (Integer)ComputeCloudAgentTemplate.checkSshConnectTimeoutSeconds(null).getValue();
        }

        public FormValidation doCheckSshConnectTimeoutSeconds(@QueryParameter String value) {
            return ComputeCloudAgentTemplate.checkSshConnectTimeoutSeconds(value).getFormValidation();
        }

        public ListBoxModel doFillSshKeyNameItems(@QueryParameter @RelativePath(value="..") String apiEndpoint, @QueryParameter @RelativePath(value="..") String identityDomainName, @QueryParameter @RelativePath(value="..") String userName, @QueryParameter @RelativePath(value="..") String password, @QueryParameter String sshKeyName) throws FormFillFailure {
            sshKeyName = FormFillFailure.getErrorValue(sshKeyName);
            try (ComputeCloudClient client = this.createFormFillClient(apiEndpoint, identityDomainName, userName, password, sshKeyName);){
                ArrayList<SSHKey> sshKeys;
                try {
                    sshKeys = new ArrayList<SSHKey>(client.getSSHKeys());
                }
                catch (ComputeCloudClientException e) {
                    throw DescriptorImpl.toFormFillFailure(e, sshKeyName);
                }
                ListBoxModel model = new ListBoxModel().add("");
                Collections.sort(sshKeys, SSHKEY_COMPARATOR);
                for (SSHKey sshkey : sshKeys) {
                    String value = sshkey.getName();
                    String displayName = ComputeCloudObjectName.parse(value).getName();
                    model.add((Object)new ListBoxModel.Option(displayName, value, value.equals(sshKeyName)));
                }
                ListBoxModel listBoxModel = model;
                return listBoxModel;
            }
        }

        private FormValidation checkSshKeyName(String value, boolean withContext) {
            FormValidation fv = FormFillFailure.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return withContext ? ComputeCloud.DescriptorImpl.withContext(fv, ConfigMessages.sshKeyName()) : fv;
            }
            return fv;
        }

        public FormValidation doCheckSshKeyName(@QueryParameter String value) {
            return this.checkSshKeyName(value, false);
        }

        PEMEncodable decodePEM(String pem) throws UnrecoverableKeyException, IOException {
            return PEMEncodable.decode((String)pem);
        }

        private FormValidationValue<RSAPublicKey> checkPrivateKey(String value, boolean withContext) {
            PEMEncodable encodable;
            FormValidation fv = JenkinsUtil.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return FormValidationValue.error(withContext ? ComputeCloud.DescriptorImpl.withContext(fv, ConfigMessages.privateKey()) : fv);
            }
            try {
                encodable = this.decodePEM(value);
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.FINE, "Failed to parse private key", e);
                return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_privateKey_invalid());
            }
            catch (UnrecoverableKeyException e) {
                LOGGER.log(Level.FINE, "Failed to parse private key", e);
                return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_privateKey_unable(e.toString()));
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to parse private key", e);
                return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_privateKey_unable(e.getMessage()));
            }
            KeyPair keyPair = encodable.toKeyPair();
            if (keyPair == null) {
                LOGGER.log(Level.FINE, "toKeyPair returned null for {0}", encodable.getRawObject());
                return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_privateKey_invalid());
            }
            PublicKey publicKey = keyPair.getPublic();
            if (!(publicKey instanceof RSAPublicKey)) {
                LOGGER.log(Level.FINE, "getPublic returned non-RSAPublicKey {0} for {1}", new Object[]{publicKey, encodable.getRawObject()});
                return FormValidationValue.error(Messages.ComputeCloudAgentTemplate_privateKey_invalid());
            }
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            return FormValidationValue.ok(rsaPublicKey);
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) {
            return this.checkPrivateKey(value, false).getFormValidation();
        }

        private FormValidation newUnableToVerifySshKeyPairFormValidation(FormValidation fv) {
            return FormValidation.error((String)Messages.ComputeCloudAgentTemplate_verifySshKeyPair_unable(JenkinsUtil.unescape(fv.getMessage())));
        }

        public FormValidation doVerifySshKeyPair(@QueryParameter String apiEndpoint, @QueryParameter String identityDomainName, @QueryParameter String userName, @QueryParameter String password, @QueryParameter String sshKeyName, @QueryParameter String privateKey) {
            SSHKey sshKey;
            FormValidation fv = this.checkSshKeyName(sshKeyName, true);
            if (fv.kind != FormValidation.Kind.OK) {
                return this.newUnableToVerifySshKeyPairFormValidation(fv);
            }
            FormValidationValue<RSAPublicKey> privateKeyValid = this.checkPrivateKey(privateKey, true);
            if (!privateKeyValid.isOk()) {
                return this.newUnableToVerifySshKeyPairFormValidation(privateKeyValid.getFormValidation());
            }
            try (ComputeCloudClient client = this.createClient(apiEndpoint, identityDomainName, userName, password);){
                sshKey = client.getSSHKey(ComputeCloudObjectName.parse(sshKeyName).getName());
            }
            catch (FormValidation fv2) {
                return fv2;
            }
            catch (ComputeCloudClientException e) {
                return ComputeCloud.DescriptorImpl.toFormValidation(e);
            }
            String sshString = SshKeyUtil.toSshString(privateKeyValid.getValue());
            if (!sshString.equals(sshKey.getKey())) {
                return FormValidation.error((String)Messages.ComputeCloudAgentTemplate_verifySshKeyPair_mismatch());
            }
            return FormValidation.ok((String)Messages.ComputeCloudAgentTemplate_verifySshKeyPair_success());
        }

        public static int getDefaultStartTimeoutSeconds() {
            return (Integer)ComputeCloudAgentTemplate.checkStartTimeoutSeconds(null).getValue();
        }

        public FormValidation doCheckStartTimeoutSeconds(@QueryParameter String value) {
            return ComputeCloudAgentTemplate.checkStartTimeoutSeconds(value).getFormValidation();
        }
    }

    static class ConfigMessages {
        static final DynamicResourceBundleHolder holder = DynamicResourceBundleHolder.get(ComputeCloudAgentTemplate.class, "config");

        ConfigMessages() {
        }

        public static String sshKeyName() {
            return holder.format("sshKeyName", new Object[0]);
        }

        public static String privateKey() {
            return holder.format("privateKey", new Object[0]);
        }
    }
}

