/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.ComputeCloud;
import com.oracle.cloud.compute.jenkins.ComputeCloudAgentTemplate;
import com.oracle.cloud.compute.jenkins.ComputeCloudComputer;
import com.oracle.cloud.compute.jenkins.JenkinsUtil;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.model.InstanceOrchestration;
import com.oracle.cloud.compute.jenkins.ssh.SshComputerLauncher;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ComputeCloudAgent
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(ComputeCloud.class.getName());
    private final String cloudName;
    private final String orchName;

    private static CloudRetentionStrategy createRetentionStrategy(String idleTerminationMinutes) {
        int idleMinutes = idleTerminationMinutes == null || idleTerminationMinutes.trim().isEmpty() ? 0 : Integer.parseInt(idleTerminationMinutes);
        return new CloudRetentionStrategy(idleMinutes);
    }

    public ComputeCloudAgent(String name, ComputeCloudAgentTemplate template, String cloudName, String orchName, String host) throws IOException, Descriptor.FormException {
        this(name, template.getDescription(), template.getRemoteFS(), template.getNumExecutors(), template.getMode(), template.getLabelString(), template.getIdleTerminationMinutes(), Collections.emptyList(), cloudName, orchName, template.getSshUserValue(), template.getSshConnectTimeoutMillis(), template.getPrivateKey(), template.getInitScript(), template.getInitScriptTimeoutSeconds(), host);
    }

    @DataBoundConstructor
    public ComputeCloudAgent(String name, String description, String remoteFS, String numExecutors, Node.Mode mode, String labelString, String idleTerminationMinutes, List<? extends NodeProperty<?>> nodeProperties, String cloudName, String orchName, String sshUser, int sshConnectTimeoutMillis, String privateKey, String initScript, int initScriptTimeoutSeconds, String host) throws IOException, Descriptor.FormException {
        super(name, description, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new SshComputerLauncher(host, sshConnectTimeoutMillis, privateKey, initScript, initScriptTimeoutSeconds, sshUser), (RetentionStrategy)ComputeCloudAgent.createRetentionStrategy(idleTerminationMinutes), nodeProperties);
        this.cloudName = cloudName;
        this.orchName = orchName;
    }

    public AbstractCloudComputer<ComputeCloudAgent> createComputer() {
        return new ComputeCloudComputer(this);
    }

    ComputeCloud getCloud() {
        return (ComputeCloud)JenkinsUtil.getJenkinsInstance().getCloud(this.getCloudName());
    }

    public String getCloudName() {
        return this.cloudName;
    }

    protected synchronized void _terminate(TaskListener listener) throws IOException, InterruptedException {
        ComputeCloud cloud = this.getCloud();
        if (cloud == null) {
            LOGGER.log(Level.SEVERE, "Unable to stop or delete orchestration {0} because the Oracle Cloud Infrastructure Compute Classic {1} does not exist", new Object[]{this.orchName, ComputeCloud.nameToCloudName(this.getCloudName())});
            return;
        }
        cloud.recycleCloudResources(this.orchName);
    }

    boolean isAlive() throws IOException, ComputeCloudClientException {
        ComputeCloud cloud = this.getCloud();
        if (cloud == null) {
            throw new IllegalStateException("the Oracle Cloud Infrastructure Compute Classic " + this.getCloudName() + " does not exist");
        }
        try (ComputeCloudClient client = cloud.createClient();){
            InstanceOrchestration.Status status = client.getInstanceOrchestration(this.orchName).getStatus();
            if (status == InstanceOrchestration.Status.ready || status == InstanceOrchestration.Status.starting || status == InstanceOrchestration.Status.updating) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Node reconfigure(StaplerRequest req, JSONObject form) {
        if (form == null) {
            return null;
        }
        return null;
    }

    @Extension
    public static class ComputeCloudAgentDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

