/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.compute.jenkins;

import com.oracle.cloud.compute.jenkins.Clock;
import com.oracle.cloud.compute.jenkins.ComputeCloudAgent;
import com.oracle.cloud.compute.jenkins.ComputeCloudAgentTemplate;
import com.oracle.cloud.compute.jenkins.ComputeCloudClientManager;
import com.oracle.cloud.compute.jenkins.ComputeCloudPlugin;
import com.oracle.cloud.compute.jenkins.DynamicResourceBundleHolder;
import com.oracle.cloud.compute.jenkins.FormValidationValue;
import com.oracle.cloud.compute.jenkins.JenkinsUtil;
import com.oracle.cloud.compute.jenkins.Messages;
import com.oracle.cloud.compute.jenkins.TimeoutHelper;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClient;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientException;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudClientUnauthorizedException;
import com.oracle.cloud.compute.jenkins.client.ComputeCloudUser;
import com.oracle.cloud.compute.jenkins.model.InstanceOrchestration;
import com.oracle.cloud.compute.jenkins.ssh.SshConnector;
import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ComputeCloud
extends AbstractCloudImpl {
    private static final Logger LOGGER = Logger.getLogger(ComputeCloud.class.getName());
    public static final String NAME_PREFIX = "oci-compute-classic-";
    public static final String ORCHESTRATION_NAME_PREFIX = "jenkins-";
    public static final String AGENT_NAME_PREFIX = "oci-compute-classic-";
    private static final long POLL_SLEEP_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long RECYCLE_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(10L);
    private final String apiEndpoint;
    private final String identityDomainName;
    private final String userName;
    private final String password;
    private final int nextTemplateId;
    private final List<? extends ComputeCloudAgentTemplate> templates;
    static final String PROVISION_ATTR_AGENT_NAME = ComputeCloud.class.getName() + ".name";
    static final String PROVISION_ATTR_NUM_EXECUTORS = ComputeCloud.class.getName() + ".numExecutors";

    static String cloudNameToName(String cloudName) {
        return "oci-compute-classic-" + cloudName.trim();
    }

    static String nameToCloudName(String name) {
        return name.substring("oci-compute-classic-".length());
    }

    @DataBoundConstructor
    public ComputeCloud(String cloudName, String apiEndpoint, String identityDomainName, String userName, String password, String instanceCapStr, int nextTemplateId, List<? extends ComputeCloudAgentTemplate> templates) {
        super(ComputeCloud.cloudNameToName(cloudName), instanceCapStr);
        this.apiEndpoint = apiEndpoint;
        this.identityDomainName = identityDomainName;
        this.userName = userName;
        this.password = this.getEncryptedValue(password);
        this.nextTemplateId = nextTemplateId;
        this.templates = templates == null ? Collections.emptyList() : templates;
    }

    public String getDisplayName() {
        return this.getCloudName();
    }

    public String getFullDisplayName() {
        return "Oracle Cloud Infrastructure Compute Classic " + this.getCloudName();
    }

    public String getCloudName() {
        return ComputeCloud.nameToCloudName(this.name);
    }

    public int getNextTemplateId() {
        return this.nextTemplateId;
    }

    public List<? extends ComputeCloudAgentTemplate> getTemplates() {
        return this.templates;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public URI getApiEndpointUrl() {
        try {
            return new URI(this.apiEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getIdentityDomainName() {
        return this.identityDomainName;
    }

    public String getUserName() {
        return this.userName;
    }

    public ComputeCloudUser getUser() {
        try {
            return ComputeCloudUser.valueOf(this.identityDomainName, this.userName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getEncryptedValue(String str) {
        return Secret.fromString((String)str).getEncryptedValue();
    }

    protected String getPlainText(String str) {
        return str == null ? null : Secret.decrypt((String)str).getPlainText();
    }

    public final String getPassword() {
        return this.getPlainText(this.password);
    }

    ExecutorService getThreadPoolForRemoting() {
        return Computer.threadPoolForRemoting;
    }

    NodeProvisioner.PlannedNode newPlannedNode(String displayName, Future<Node> future, int numExecutors, ComputeCloudAgentTemplate template) {
        return new NodeProvisioner.PlannedNode(displayName, future, numExecutors);
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        int numExecutors;
        ComputeCloudAgentTemplate t = this.getTemplate(label);
        if (t == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
        for (int numAgents = this.countCurrentComputeCloudAgents(); excessWorkload > 0 && numAgents < this.getInstanceCap(); excessWorkload -= numExecutors, ++numAgents) {
            Provisioner provisioner = new Provisioner(t);
            String displayName = provisioner.getPlannedNodeDisplayName();
            Future<Node> future = this.getThreadPoolForRemoting().submit(provisioner);
            numExecutors = provisioner.numExecutors;
            r.add(this.newPlannedNode(displayName, future, numExecutors, t));
        }
        return r;
    }

    ComputeCloudAgent newComputeCloudAgent(String name, ComputeCloudAgentTemplate template, String cloudName, String orchName, String host) throws IOException, Descriptor.FormException {
        return new ComputeCloudAgent(name, template, cloudName, orchName, host);
    }

    protected void stopAndDeleteOrchestration(ComputeCloudClient client, long timeoutNanos, String orchName) throws ComputeCloudClientException, InterruptedException, IOException {
        TimeoutHelper timeoutHelper = new TimeoutHelper(this.getClock(), timeoutNanos, POLL_SLEEP_MILLIS);
        do {
            InstanceOrchestration instanceOrch;
            InstanceOrchestration.Status status;
            if ((status = (instanceOrch = client.getInstanceOrchestration(orchName)).getStatus()) == InstanceOrchestration.Status.error && instanceOrch.getErrors() != null && instanceOrch.getErrors().size() > 0) {
                StringBuilder errMsgBuilder = new StringBuilder();
                for (String msg : instanceOrch.getErrors()) {
                    errMsgBuilder.append("\n");
                    errMsgBuilder.append(msg);
                }
                LOGGER.warning("Orchestration " + orchName + " in error status would be recycled, error messages:" + errMsgBuilder.toString());
            }
            if (status != InstanceOrchestration.Status.stopped && status != InstanceOrchestration.Status.stopping) {
                client.stopOrchestration(orchName);
            }
            if (status != InstanceOrchestration.Status.stopped) continue;
            client.deleteOrchestration(orchName);
            return;
        } while (timeoutHelper.sleep());
        throw new IOException("Provision node: " + orchName + " failed, AND CREATED RESOURCES FAILED TO RECYCLE, REQUIRE MANUAL OPERATION!!!");
    }

    public void recycleCloudResources(String orchName) throws InterruptedException, IOException {
        try (ComputeCloudClient client = this.createClient();){
            this.stopAndDeleteOrchestration(client, RECYCLE_TIMEOUT_NANOS, orchName);
        }
        catch (ComputeCloudClientException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ComputeCloudAgent provision(String name, ComputeCloudAgentTemplate template, String orchName) throws Exception {
        LOGGER.info("Provisioning new node with Oracle Cloud Infrastructure Compute Classic orchestration " + orchName);
        try {
            Throwable throwable = null;
            try (ComputeCloudClient client = this.createClient();){
                client.createInstanceOrchestration(orchName, template);
                TimeoutHelper timeoutHelper = new TimeoutHelper(this.getClock(), template.getStartTimeoutNanos(), POLL_SLEEP_MILLIS);
                try {
                    InstanceOrchestration instance = this.startInstanceAndAwait(client, orchName, timeoutHelper);
                    String ip = instance.getIp();
                    LOGGER.info("Provisioned orchestration " + orchName + " with public ip " + ip);
                    this.awaitInstanceSshAvailable(ip, template.getSshConnectTimeoutMillis(), timeoutHelper);
                    template.resetFailureCount();
                    ComputeCloudAgent computeCloudAgent = this.newComputeCloudAgent(name, template, this.name, orchName, ip);
                    return computeCloudAgent;
                }
                catch (Exception e) {
                    try {
                        try {
                            this.stopAndDeleteOrchestration(client, template.getStartTimeoutNanos(), orchName);
                            LOGGER.log(Level.WARNING, "Provision node: " + orchName + " failed, and created resources have been recycled.", e);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, "Provision node: " + orchName + " failed, and failed to recycle node " + orchName, ex);
                        }
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Exception e) {
            template.increaseFailureCount(e.getMessage());
            throw e;
        }
    }

    Clock getClock() {
        return Clock.INSTANCE;
    }

    private InstanceOrchestration startInstanceAndAwait(ComputeCloudClient client, String orchName, TimeoutHelper timeoutHelper) throws Exception {
        client.startOrchestration(orchName);
        do {
            InstanceOrchestration instanceOrch;
            InstanceOrchestration.Status status;
            if ((status = (instanceOrch = client.getInstanceOrchestration(orchName)).getStatus()) == InstanceOrchestration.Status.ready) {
                return instanceOrch;
            }
            if (status == InstanceOrchestration.Status.starting) continue;
            throw new IOException("Instance " + orchName + " has status " + (Object)((Object)status) + " rather than starting or ready");
        } while (timeoutHelper.sleep());
        IOException ex = new IOException("Timed out waiting for orchestration to have ready status");
        LOGGER.log(Level.WARNING, "Timed out waiting for orchestration to have ready status", ex);
        throw ex;
    }

    SshConnector getSshConnector() {
        return SshConnector.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitInstanceSshAvailable(String host, int connectTimeoutMillis, TimeoutHelper timeoutHelper) throws IOException, InterruptedException {
        SshConnector sshConnector = this.getSshConnector();
        do {
            try (Connection conn = sshConnector.createConnection(host);){
                sshConnector.connect(conn, connectTimeoutMillis);
                return;
            }
        } while (timeoutHelper.sleep());
        throw new IOException("Timed out connecting to SSH");
    }

    List<Node> getNodes() {
        return JenkinsUtil.getJenkinsInstance().getNodes();
    }

    public int countCurrentComputeCloudAgents() {
        int r = 0;
        for (Node n : this.getNodes()) {
            ComputeCloudAgent agent;
            if (!(n instanceof ComputeCloudAgent) || !this.name.equals((agent = (ComputeCloudAgent)n).getCloudName())) continue;
            ++r;
        }
        return r;
    }

    public ComputeCloudAgentTemplate getTemplate(Label label) {
        for (ComputeCloudAgentTemplate computeCloudAgentTemplate : this.templates) {
            if (computeCloudAgentTemplate.getDisableCause() != null || !(computeCloudAgentTemplate.getMode() == Node.Mode.NORMAL ? label == null || label.matches(computeCloudAgentTemplate.getLabelAtoms()) : computeCloudAgentTemplate.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(computeCloudAgentTemplate.getLabelAtoms()))) continue;
            return computeCloudAgentTemplate;
        }
        return null;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void doProvision(@QueryParameter int templateId, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        ComputeCloudAgentTemplate template = this.getTemplateById(templateId);
        if (template == null) {
            this.sendError(Messages.ComputeCloud_provision_templateNotFound(), req, rsp);
            return;
        }
        if (template.getDisableCause() != null) {
            this.sendError(Messages.ComputeCloud_provision_templateDisabled(), req, rsp);
            return;
        }
        ExplicitProvisioner provisioner = new ExplicitProvisioner(template);
        this.getThreadPoolForRemoting().submit(provisioner);
        req.setAttribute(PROVISION_ATTR_AGENT_NAME, (Object)provisioner.name);
        req.setAttribute(PROVISION_ATTR_NUM_EXECUTORS, (Object)provisioner.numExecutors);
        req.getView((Object)this, "provision").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    void addNode(Node node) throws IOException {
        JenkinsUtil.getJenkinsInstance().addNode(node);
    }

    private ComputeCloudAgentTemplate getTemplateById(int templateId) {
        for (ComputeCloudAgentTemplate computeCloudAgentTemplate : this.templates) {
            if (computeCloudAgentTemplate.getTemplateId() != templateId) continue;
            return computeCloudAgentTemplate;
        }
        return null;
    }

    public Class<?> getProvisionSidePanelClass() {
        return ComputerSet.class;
    }

    public String getProvisionStartedMessage(HttpServletRequest req) {
        String name = (String)req.getAttribute(PROVISION_ATTR_AGENT_NAME);
        Integer numExecutors = (Integer)req.getAttribute(PROVISION_ATTR_NUM_EXECUTORS);
        return Messages.ComputeCloud_provision_started(name, numExecutors);
    }

    public HttpResponse doIndex() throws IOException {
        return HttpResponses.redirectTo((String)"../../computer/");
    }

    public ComputeCloudClient createClient() {
        return ComputeCloudPlugin.CLIENT_MANAGER.createClient(this);
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public static final String DISPLAY_NAME = "Oracle Cloud Infrastructure Compute Classic";

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        List<? extends Cloud> getClouds() {
            return JenkinsUtil.getJenkinsInstance().clouds;
        }

        public FormValidation doCheckCloudName(@QueryParameter String value) {
            value = value.trim();
            try {
                Jenkins.checkGoodName((String)value);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            String name = ComputeCloud.cloudNameToName(value);
            int found = 0;
            for (Cloud cloud : this.getClouds()) {
                if (!cloud.name.equals(name)) continue;
                ++found;
            }
            if (found > 1) {
                return FormValidation.error((String)Messages.ComputeCloud_cloudName_duplicate(value));
            }
            return FormValidation.ok();
        }

        public static FormValidation withContext(FormValidation fv, String context) {
            return FormValidation.error((String)(JenkinsUtil.unescape(fv.getMessage()) + ": " + context));
        }

        private FormValidationValue<URI> checkApiEndpoint(String value, boolean withContext) {
            URI uri;
            FormValidation fv = JenkinsUtil.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return FormValidationValue.error(withContext ? DescriptorImpl.withContext(fv, ConfigMessages.apiEndpoint()) : fv);
            }
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException e) {
                return FormValidationValue.error(Messages.ComputeCloud_apiEndpoint_invalidUrl());
            }
            if (!uri.isAbsolute() || !uri.getScheme().startsWith("http")) {
                return FormValidationValue.error(Messages.ComputeCloud_apiEndpoint_invalidUrlScheme());
            }
            return FormValidationValue.ok(uri);
        }

        public FormValidation doCheckApiEndpoint(@QueryParameter String value) {
            return this.checkApiEndpoint(value, false).getFormValidation();
        }

        private boolean isValidUser(String identityDomainName, String userName) {
            try {
                ComputeCloudUser.valueOf(identityDomainName, userName);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private FormValidation checkIdentityDomainName(String value, boolean withContext) {
            FormValidation fv = JenkinsUtil.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return withContext ? DescriptorImpl.withContext(fv, ConfigMessages.identityDomainName()) : fv;
            }
            if (!this.isValidUser(value, "x")) {
                return FormValidation.error((String)Messages.ComputeCloud_identityDomainName_invalid());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdentityDomainName(@QueryParameter String value) {
            return this.checkIdentityDomainName(value, false);
        }

        public FormValidation checkUserName(String value, boolean withContext) {
            FormValidation fv = JenkinsUtil.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return withContext ? DescriptorImpl.withContext(fv, ConfigMessages.userName()) : fv;
            }
            if (!this.isValidUser("x", value)) {
                return FormValidation.error((String)Messages.ComputeCloud_userName_invalid());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUserName(@QueryParameter String value) {
            return this.checkUserName(value, false);
        }

        private FormValidation checkPassword(String value, boolean withContext) {
            FormValidation fv = JenkinsUtil.validateRequired(value);
            if (fv.kind != FormValidation.Kind.OK) {
                return withContext ? DescriptorImpl.withContext(fv, ConfigMessages.password()) : fv;
            }
            return fv;
        }

        ComputeCloudClientManager getComputeCloudClientManager() {
            return ComputeCloudPlugin.CLIENT_MANAGER;
        }

        private FormValidation newUnableToConnectException(FormValidation fv) {
            return FormValidation.error((String)Messages.ComputeCloud_testConnection_unable(JenkinsUtil.unescape(fv.getMessage())));
        }

        public ComputeCloudClient createClient(String apiEndpoint, String identityDomainName, String userName, String password) throws FormValidation {
            FormValidationValue<URI> apiEndpointValid = this.checkApiEndpoint(apiEndpoint, true);
            if (!apiEndpointValid.isOk()) {
                throw this.newUnableToConnectException(apiEndpointValid.getFormValidation());
            }
            FormValidation fv = this.checkIdentityDomainName(identityDomainName, true);
            if (fv.kind != FormValidation.Kind.OK) {
                throw this.newUnableToConnectException(fv);
            }
            fv = this.checkUserName(userName, true);
            if (fv.kind != FormValidation.Kind.OK) {
                throw this.newUnableToConnectException(fv);
            }
            fv = this.checkPassword(password, true);
            if (fv.kind != FormValidation.Kind.OK) {
                throw this.newUnableToConnectException(fv);
            }
            URI apiEndpointUrl = apiEndpointValid.getValue();
            ComputeCloudUser user = ComputeCloudUser.valueOf(identityDomainName, userName);
            return this.getComputeCloudClientManager().createClient(apiEndpointUrl, user, password);
        }

        public static FormValidation toFormValidation(ComputeCloudClientException e) {
            LOGGER.log(Level.FINE, "Failed to connect to Oracle Cloud Infrastructure Compute Classic", e);
            if (e instanceof ComputeCloudClientUnauthorizedException) {
                return FormValidation.error((String)Messages.ComputeCloud_testConnection_unauthorized());
            }
            return FormValidation.error((String)Messages.ComputeCloud_testConnection_error(e.getMessage()));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestConnection(@QueryParameter String apiEndpoint, @QueryParameter String identityDomainName, @QueryParameter String userName, @QueryParameter String password) {
            try (ComputeCloudClient client = this.createClient(apiEndpoint, identityDomainName, userName, password);){
                client.authenticate();
                FormValidation formValidation = FormValidation.ok((String)Messages.ComputeCloud_testConnection_success());
                return formValidation;
            }
            catch (FormValidation fv) {
                return fv;
            }
            catch (ComputeCloudClientException e) {
                return DescriptorImpl.toFormValidation(e);
            }
        }
    }

    static class ConfigMessages {
        static final DynamicResourceBundleHolder holder = DynamicResourceBundleHolder.get(ComputeCloud.class, "config");

        ConfigMessages() {
        }

        public static String apiEndpoint() {
            return holder.format("apiEndpoint", new Object[0]);
        }

        public static String identityDomainName() {
            return holder.format("identityDomainName", new Object[0]);
        }

        public static String userName() {
            return holder.format("userName", new Object[0]);
        }

        public static String password() {
            return holder.format("password", new Object[0]);
        }
    }

    private class ExplicitProvisioner
    extends Provisioner {
        ExplicitProvisioner(ComputeCloudAgentTemplate template) {
            super(template);
        }

        @Override
        public Node call() throws Exception {
            String displayName = this.getPlannedNodeDisplayName();
            try {
                ComputeCloud.this.addNode(super.call());
                LOGGER.log(Level.INFO, "{0} provisioning successfully completed", displayName);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Provisioned slave " + displayName + " failed!", e);
            }
            return null;
        }
    }

    private class Provisioner
    implements Callable<Node> {
        final ComputeCloudAgentTemplate template;
        final int numExecutors;
        final String name;
        final String orchName;

        Provisioner(ComputeCloudAgentTemplate template) {
            this.template = template;
            this.numExecutors = template.getNumExecutorsValue();
            UUID uuid = UUID.randomUUID();
            this.name = "oci-compute-classic-" + uuid;
            this.orchName = ComputeCloud.ORCHESTRATION_NAME_PREFIX + uuid;
        }

        public String getPlannedNodeDisplayName() {
            return this.orchName;
        }

        @Override
        public Node call() throws Exception {
            return ComputeCloud.this.provision(this.name, this.template, this.orchName);
        }
    }
}

