/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.operations;

import com.arkea.jenkins.openstack.client.OpenStack4jClient;
import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.HOTPlayerSettings;
import com.arkea.jenkins.openstack.heat.configuration.ProjectOS;
import com.arkea.jenkins.openstack.heat.configuration.TimersOS;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.loader.AbstractLoader;
import com.arkea.jenkins.openstack.heat.orchestration.template.Bundle;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.OutputUtils;
import com.arkea.jenkins.openstack.log.ConsoleLogger;
import com.arkea.jenkins.openstack.operations.EnvVarsUtils;
import com.arkea.jenkins.openstack.pool.ProcessStatus;
import com.arkea.jenkins.openstack.pool.StackStatus;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.openstack4j.model.heat.Stack;

public class StackOperationsUtils {
    public static boolean deleteStack(String stackName, OpenStack4jClient client, ConsoleLogger cLog, TimersOS timersOS) {
        boolean rtn = true;
        try {
            Stack stackDelete = client.getStackByName(stackName);
            if (stackDelete != null) {
                cLog.logInfo(Messages.stack_existing(stackName));
                cLog.logInfo(Messages.delete_progress());
                client.deleteStack(stackDelete);
                if (ProcessStatus.checkStackStatus(StackStatus.DELETE_COMPLETE, client, cLog, stackDelete, timersOS)) {
                    cLog.logInfo(Messages.stack_deleted(stackName));
                } else {
                    rtn = false;
                }
            }
        }
        catch (Exception e) {
            cLog.logError(Messages.delete_failed(stackName) + e.getMessage() + ExceptionUtils.getStackTrace(e));
            rtn = false;
        }
        return rtn;
    }

    public static boolean createStack(EnvVarsUtils eVU, Bundle bundle, ProjectOS projectOS, OpenStack4jClient client, ConsoleLogger cLog, TimersOS timersOS) {
        boolean rtn = true;
        String bundleName = eVU.getVar(bundle.getName());
        try {
            Stack stackCreate;
            cLog.logInfo(Messages.stack_start(bundleName, projectOS.getProject()));
            cLog.logInfo(bundle.getTags());
            Map<String, String> vars = eVU.getVars(bundle.getParamsOS());
            cLog.logDebugMap(Messages.stack_parameters(), vars);
            AbstractLoader loader = ((HOTPlayerSettings)Jenkins.getInstance().getDescriptor(HOTPlayerSettings.class)).getLoader();
            String envFile = bundle.getEnvName();
            if (!Strings.isNullOrEmpty((String)envFile)) {
                envFile = loader.getFullPathEnv(envFile);
            }
            if (ProcessStatus.checkStackStatus(StackStatus.CREATE_COMPLETE, client, cLog, stackCreate = bundle.isTag() && !Strings.isNullOrEmpty((String)bundle.getTags()) ? client.createStack(bundleName, loader.getFullPathHot(bundle.getHotName()), bundle.getTags(), eVU.getVars(bundle.getParamsOS()), envFile, timersOS.getTimeoutProcessInMin()) : client.createStack(bundleName, loader.getFullPathHot(bundle.getHotName()), null, eVU.getVars(bundle.getParamsOS()), envFile, timersOS.getTimeoutProcessInMin()), timersOS)) {
                TreeMap<String, String> outputs = new TreeMap<String, String>();
                List exits = client.getDetails(bundleName, stackCreate.getId()).getOutputs();
                Collections.sort(exits, OutputUtils.getComparatorAlphabetical());
                for (Map output : exits) {
                    if (output.get("output_value") instanceof String) {
                        outputs.put((String)output.get("output_key"), String.valueOf(output.get("output_value")));
                        continue;
                    }
                    outputs.put((String)output.get("output_key"), JSONObject.fromObject(output.get("output_value")).toString());
                }
                cLog.logDebugMap(Messages.stack_outputs(), outputs);
                eVU.setVars(bundle.getOutputs(), outputs);
            } else {
                rtn = false;
            }
        }
        catch (Exception e) {
            cLog.logError(Messages.stack_failed(bundleName) + ExceptionUtils.getStackTrace(e));
            rtn = false;
        }
        return rtn;
    }
}

