/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template;

import com.arkea.jenkins.openstack.heat.orchestration.template.Output;
import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class Bundle {
    private String hotName;
    private String name;
    private String tags;
    private boolean exist;
    private boolean debug;
    private boolean tag;
    private Map<String, Parameter> parameters = new TreeMap<String, Parameter>();
    private Map<String, Output> outputs = new TreeMap<String, Output>();
    private String envName;

    public Bundle(String hotName, String name, String tags, boolean tag, boolean exist, boolean debug) {
        this.hotName = hotName;
        this.name = name;
        this.exist = exist;
        this.debug = debug;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getHotName() {
        return this.hotName;
    }

    public String getName() {
        return this.name;
    }

    public void setTag(boolean tag) {
        this.tag = tag;
    }

    public boolean isTag() {
        return this.tag;
    }

    public boolean isExist() {
        return this.exist;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, Output> getOutputs() {
        return this.outputs;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setOutputs(Map<String, Output> outputs) {
        this.outputs = outputs;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public Map<String, String> getParamsOS() {
        TreeMap<String, String> paramsOS = new TreeMap<String, String>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            if (entry.getValue().getValue() != null && !StringUtils.isEmpty((String)entry.getValue().getValue())) {
                paramsOS.put(entry.getKey(), this.convertValue(entry.getValue().getValue()));
                continue;
            }
            if (entry.getValue().getDefaultValue() != null && !StringUtils.isEmpty((String)this.convertValue(entry.getValue().getDefaultValue()))) {
                paramsOS.put(entry.getKey(), this.convertValue(entry.getValue().getDefaultValue()));
                continue;
            }
            paramsOS.put(entry.getKey(), "");
        }
        return paramsOS;
    }

    private String convertValue(Object value) {
        if (value instanceof LinkedHashMap) {
            StringBuilder rtn = new StringBuilder("{");
            LinkedHashMap data = (LinkedHashMap)value;
            for (Map.Entry entry : data.entrySet()) {
                rtn.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(",");
            }
            rtn.deleteCharAt(rtn.length() - 1);
            rtn.append("}");
            return rtn.toString();
        }
        return String.valueOf(value);
    }
}

