/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.log;

import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.log.ConsoleAnnotator;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Map;

public class ConsoleLogger {
    private PrintStream printStream;
    private ConsoleAnnotator annotator;
    private boolean debug;

    public ConsoleLogger(PrintStream printStream, String pattern, boolean debug) {
        this.annotator = new ConsoleAnnotator(printStream, pattern);
        this.printStream = printStream;
        this.debug = debug;
    }

    public ConsoleAnnotator getAnnotator() {
        return this.annotator;
    }

    public void logDebug(String message) {
        if (this.debug) {
            this.logAnnot(this.annotator.getPattern() + Messages.log_debug(), message);
        }
    }

    public void logDebugMap(String title, Map<String, String> map) {
        if (this.debug) {
            this.logAnnot(this.annotator.getPattern() + Messages.log_debug(), title);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.logAnnot(this.annotator.getPattern() + Messages.log_debug(), Messages.log_map(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void logInfo(String message) {
        this.logAnnot(this.annotator.getPattern() + Messages.log_info(), message);
    }

    public void logWarn(String message) {
        this.logAnnot(this.annotator.getPattern() + Messages.log_warn(), message);
    }

    public void logError(String message) {
        this.logAnnot(this.annotator.getPattern() + Messages.log_error(), message);
    }

    public void logAnnot(String prefix, String message) {
        byte[] msg = (prefix + message + "\n").getBytes(Charset.defaultCharset());
        try {
            this.annotator.eol(msg, msg.length);
        }
        catch (IOException e) {
            this.printStream.println(Messages.consoleLogger_error() + e.getMessage() + ExceptionUtils.getStackTrace(e));
        }
    }

    public void log(String message) {
        this.printStream.println(message);
    }

    public boolean isDebug() {
        return this.debug;
    }
}

