/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.constraints;

import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AbstractConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintType;
import com.google.common.base.Strings;
import java.util.Map;

public class AllowedValuesConstraint
extends AbstractConstraint {
    private Map<String, String> allowed_values;

    AllowedValuesConstraint() {
        super(ConstraintType.allowed_values);
    }

    AllowedValuesConstraint(Map<String, String> allowed_values) {
        this();
        this.allowed_values = allowed_values;
    }

    public Map<String, String> getAllowed_values() {
        return this.allowed_values;
    }

    public void setAllowed_values(Map<String, String> allowed_values) {
        this.allowed_values = allowed_values;
    }

    @Override
    public boolean checkConstraint(Parameter parameter) {
        String testValue = (String)parameter.getDefaultValue();
        if (!Strings.isNullOrEmpty((String)parameter.getValue())) {
            testValue = parameter.getValue();
        }
        for (Map.Entry<String, String> entry : this.allowed_values.entrySet()) {
            if (!testValue.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

