/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.loader;

import com.arkea.jenkins.openstack.exception.utils.FormExceptionUtils;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.loader.AbstractLoader;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LoaderHttpREST
extends AbstractLoader {
    private static Logger LOG = Logger.getLogger(LoaderHttpREST.class.getName());
    private String urlHot;
    private boolean checkEnv = false;
    private String urlEnv;
    private String defaultEnv;

    @DataBoundConstructor
    public LoaderHttpREST(String urlHot, JSONObject httpRESTEnv) {
        this.urlHot = urlHot;
        if (httpRESTEnv != null) {
            this.checkEnv = true;
            this.urlEnv = httpRESTEnv.getString("urlEnv");
            this.defaultEnv = httpRESTEnv.getString("defaultEnv");
        }
    }

    public String getUrlHot() {
        return this.urlHot;
    }

    public boolean isCheckEnv() {
        return this.checkEnv;
    }

    public String getUrlEnv() {
        return this.urlEnv;
    }

    public String getDefaultEnv() {
        return this.defaultEnv;
    }

    @Override
    public String[] getHots() {
        return LoaderHttpRESTDescriptor.getListFiles(this.urlHot);
    }

    @Override
    public String getHot(String hotName) {
        return this.getFile(this.urlHot, hotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFile(String path, String name) {
        StringBuilder contents = new StringBuilder();
        try (Scanner scanner = null;){
            scanner = new Scanner(new URL(path + "/" + name).openStream(), "UTF-8");
            while (scanner.hasNextLine()) {
                contents.append(scanner.nextLine()).append('\n');
            }
        }
        return contents.toString();
    }

    @Override
    public boolean checkData() throws Descriptor.FormException {
        if (Strings.isNullOrEmpty((String)this.urlHot)) {
            throw FormExceptionUtils.getFormException(Messages.urlHot_label(), Messages.urlHot_name());
        }
        if (this.isCheckEnv() && Strings.isNullOrEmpty((String)this.urlEnv)) {
            throw FormExceptionUtils.getFormException(Messages.urlEnv_label(), Messages.urlEnv_name());
        }
        return true;
    }

    @Override
    public String getFullPathHot(String hotName) {
        return this.urlHot + "/" + hotName;
    }

    @Override
    public String getFullPathEnv(String envFile) {
        return this.urlEnv + "/" + envFile;
    }

    @Override
    public String[] getEnvs() {
        return LoaderHttpRESTDescriptor.getListFiles(this.urlEnv);
    }

    @Override
    public String getEnv(String envName) {
        return this.getFile(this.urlEnv, envName);
    }

    @Override
    public String getDefaultEnvFileName() {
        return this.defaultEnv;
    }

    @Extension
    public static class LoaderHttpRESTDescriptor
    extends AbstractLoader.AbstractLoaderDescriptor {
        public String getDisplayName() {
            return "LoaderHttpREST";
        }

        public FormValidation doTestUrlHot(@QueryParameter(value="urlHot") String urlHot) throws IOException {
            return this.doTestUrl(urlHot);
        }

        public FormValidation doTestUrlEnv(@QueryParameter(value="urlEnv") String urlEnv) throws IOException {
            return this.doTestUrl(urlEnv);
        }

        private FormValidation doTestUrl(String url) throws IOException {
            if (Strings.isNullOrEmpty((String)url)) {
                return FormValidation.warning((String)Messages.input_filled(Messages.urlHot_label()));
            }
            String[] data = LoaderHttpRESTDescriptor.getListFiles(url);
            if (data.length == 0) {
                return FormValidation.error((String)Messages.formValidation_errorUrl(url));
            }
            return FormValidation.ok((String)Messages.formValidation_success());
        }

        protected static String[] getListFiles(String url) {
            String[] list = new String[]{};
            try {
                list = (String[])new ObjectMapper().readValue(new URL(url), (TypeReference)new TypeReference<String[]>(){});
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, Messages.file_notFound(url), e.fillInStackTrace());
            }
            return list;
        }
    }
}

