/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat;

import com.arkea.jenkins.openstack.exception.utils.FormExceptionUtils;
import com.arkea.jenkins.openstack.heat.configuration.ProjectOS;
import com.arkea.jenkins.openstack.heat.configuration.TimersOS;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.loader.AbstractLoader;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class HOTPlayerSettings
extends GlobalConfiguration {
    private AbstractLoader loader;
    private TimersOS timersOS = new TimersOS();
    private List<ProjectOS> projects = new ArrayList<ProjectOS>();

    public HOTPlayerSettings() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.projects = new ArrayList<ProjectOS>();
        req.bindJSON((Object)this, formData);
        this.checkData();
        this.save();
        return true;
    }

    public AbstractLoader getLoader() {
        return this.loader;
    }

    public void setLoader(AbstractLoader loader) {
        this.loader = loader;
    }

    public long getPollingStatus() {
        return this.timersOS.getPollingStatus();
    }

    public void setPollingStatus(long pollingStatus) {
        this.timersOS.setPollingStatus(pollingStatus);
    }

    public long getTimeoutProcess() {
        return this.timersOS.getTimeoutProcess();
    }

    public void setTimeoutProcess(long timeoutProcess) {
        this.timersOS.setTimeoutProcess(timeoutProcess);
    }

    public TimersOS getTimersOS() {
        return this.timersOS;
    }

    public List<ProjectOS> getProjects() {
        return this.projects;
    }

    public void setProjects(List<ProjectOS> projects) {
        this.projects = projects;
    }

    public boolean checkData() throws Descriptor.FormException {
        if (this.loader == null) {
            throw FormExceptionUtils.getFormException(Messages.loader_label(), Messages.loader_name());
        }
        this.loader.checkData();
        if (this.timersOS.getPollingStatus() <= 0L) {
            throw FormExceptionUtils.getFormException(Messages.pollingStatus_label(), Messages.pollingStatus_name());
        }
        if (this.timersOS.getTimeoutProcess() <= 0L) {
            throw FormExceptionUtils.getFormException(Messages.timeoutProcess_label(), Messages.timeoutProcess_name());
        }
        if (this.projects.isEmpty()) {
            throw FormExceptionUtils.getFormException(Messages.projectConfiguration_label(), Messages.projectConfiguration_name());
        }
        for (ProjectOS project : this.projects) {
            project.checkData();
        }
        return true;
    }
}

