/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat;

import com.arkea.jenkins.openstack.client.OpenStack4jClient;
import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.HOTPlayerSettings;
import com.arkea.jenkins.openstack.heat.configuration.ProjectOS;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.orchestration.template.Bundle;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.BundleMapperUtils;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.EnvMapperUtils;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.HOTMapperUtils;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.ParameterUtils;
import com.arkea.jenkins.openstack.log.ConsoleLogger;
import com.arkea.jenkins.openstack.operations.EnvVarsUtils;
import com.arkea.jenkins.openstack.operations.StackOperationsUtils;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class HOTPlayer
extends Builder {
    private String hotName;
    private String envName;
    private Bundle bundle;
    private String project;
    private OpenStack4jClient clientOS;

    @DataBoundConstructor
    public HOTPlayer(String project, Bundle bundle) {
        this.project = project;
        this.hotName = bundle.getHotName();
        this.envName = bundle.getEnvName();
        this.bundle = bundle;
    }

    public HOTPlayer(String project, Bundle bundle, OpenStack4jClient clientOS) {
        this.project = project;
        this.hotName = bundle.getHotName();
        this.envName = bundle.getEnvName();
        this.bundle = bundle;
        this.clientOS = clientOS;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getHotName() {
        return this.hotName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public JSONObject getBundle() {
        return JSONObject.fromObject((Object)this.bundle);
    }

    public String getProject() {
        return this.project;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ConsoleLogger cLog = new ConsoleLogger(listener.getLogger(), "HOT Player ", this.bundle.isDebug());
        try {
            JSONArray stacks;
            EnvVarsUtils eVU = new EnvVarsUtils(build, listener, cLog);
            HOTPlayerSettings hPS = (HOTPlayerSettings)Jenkins.getInstance().getDescriptor(HOTPlayerSettings.class);
            ProjectOS projectOS = (ProjectOS)CollectionUtils.find(hPS.getProjects(), (Predicate)new Predicate(){

                public boolean evaluate(Object o) {
                    return HOTPlayer.this.project.equals(((ProjectOS)o).getProject());
                }
            });
            if (projectOS != null) {
                if (this.clientOS == null || !this.clientOS.isConnectionOK()) {
                    this.clientOS = new OpenStack4jClient(projectOS);
                }
                if (this.bundle.isExist() && !StackOperationsUtils.deleteStack(eVU.getVar(this.bundle.getName()), this.clientOS, cLog, hPS.getTimersOS())) {
                    return false;
                }
                if (!StackOperationsUtils.createStack(eVU, this.bundle, projectOS, this.clientOS, cLog, hPS.getTimersOS())) {
                    return false;
                }
                stacks = new JSONArray();
                if (StringUtils.isNotEmpty((String)eVU.getValue("stacks_to_delete"))) {
                    stacks = JSONArray.fromObject((Object)eVU.getValue("stacks_to_delete"));
                }
            } else {
                cLog.logError(Messages.project_notFound(this.project));
                return false;
            }
            stacks.add((Object)new JSONObject().accumulate("project", (Object)projectOS.toJSON()).accumulate("stackName", (Object)eVU.getVar(this.bundle.getName())));
            eVU.setVar("stacks_to_delete", stacks.toString());
        }
        catch (Exception e) {
            cLog.logError(Messages.processing_failed(this.bundle.getName()) + ExceptionUtils.getStackTrace(e));
            return false;
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private HOTPlayerSettings hotPlayerSettings;

        public DescriptorImpl() {
        }

        @Inject
        public DescriptorImpl(HOTPlayerSettings hotPlayerSettings) {
            this.hotPlayerSettings = hotPlayerSettings;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            try {
                return this.hotPlayerSettings.checkData();
            }
            catch (Descriptor.FormException e) {
                return false;
            }
        }

        public String getDisplayName() {
            return "Heat Orchestration Template (HOT) player";
        }

        public String[] getHotItems() {
            return this.hotPlayerSettings.getLoader().getHots();
        }

        public String[] getEnvItems() {
            return this.hotPlayerSettings.getLoader().getEnvs();
        }

        public String getDefaultEnvFileName() {
            return this.hotPlayerSettings.getLoader().getDefaultEnvFileName();
        }

        public List<ProjectOS> getProjects() {
            return this.hotPlayerSettings.getProjects();
        }

        @JavaScriptMethod
        public JSONObject getBundle(String hotName) {
            String body = this.hotPlayerSettings.getLoader().getHot(hotName);
            if (Strings.isNullOrEmpty((String)body)) {
                return null;
            }
            return JSONObject.fromObject((Object)HOTMapperUtils.getBundleFromHOT(hotName, body));
        }

        @JavaScriptMethod
        public JSONObject getEnv(String envName) {
            return JSONObject.fromObject((Object)EnvMapperUtils.getEnv(this.hotPlayerSettings.getLoader().getEnv(envName)));
        }

        public HOTPlayer newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Bundle bundle;
            String data = formData.getString("bundle");
            if (Strings.isNullOrEmpty((String)data)) {
                throw new Descriptor.FormException(Messages.bundle_configurationException(), "ConfigurationException");
            }
            try {
                bundle = BundleMapperUtils.getBundleFromJson(data);
                if (!bundle.getParameters().isEmpty()) {
                    ParameterUtils.checkContraints(bundle.getParameters());
                }
                if (formData.containsKey((Object)"envName") && !Strings.isNullOrEmpty((String)formData.getString("envName"))) {
                    bundle.setEnvName(formData.getString("envName"));
                }
            }
            catch (IOException e) {
                throw new Descriptor.FormException(Messages.bundle_constraintsException(), "ConstraintsException");
            }
            return new HOTPlayer(formData.getString("project"), bundle);
        }
    }
}

