/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat;

import com.arkea.jenkins.openstack.client.OpenStack4jClient;
import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.HOTPlayerSettings;
import com.arkea.jenkins.openstack.heat.configuration.ProjectOS;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.log.ConsoleLogger;
import com.arkea.jenkins.openstack.operations.EnvVarsUtils;
import com.arkea.jenkins.openstack.operations.StackOperationsUtils;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class HOTClean
extends Publisher {
    private OpenStack4jClient clientOS;

    @DataBoundConstructor
    public HOTClean() {
    }

    public HOTClean(OpenStack4jClient clientOS) {
        this.clientOS = clientOS;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ConsoleLogger cLog = new ConsoleLogger(listener.getLogger(), "HOT Clean ", false);
        try {
            EnvVarsUtils eVU = new EnvVarsUtils(build, listener, cLog);
            if (Strings.isNullOrEmpty((String)eVU.getValue("stacks_to_delete"))) {
                cLog.logInfo(Messages.stacksToDelete_empty());
            } else {
                HOTPlayerSettings hPS = (HOTPlayerSettings)Jenkins.getInstance().getDescriptor(HOTPlayerSettings.class);
                JSONArray stacks = JSONArray.fromObject((Object)eVU.getValue("stacks_to_delete"));
                for (Object stackToDelete : stacks) {
                    JSONObject stack = (JSONObject)stackToDelete;
                    String stackName = stack.getString("stackName");
                    ProjectOS project = new ProjectOS(stack.getJSONObject("project"));
                    if (this.clientOS == null || !this.clientOS.isConnectionOK()) {
                        this.clientOS = new OpenStack4jClient(project);
                    }
                    cLog.logInfo(Messages.stacksToDelete_process(stackName, project.getProject()));
                    if (StackOperationsUtils.deleteStack(eVU.getVar(stackName), this.clientOS, cLog, hPS.getTimersOS())) continue;
                    cLog.logError(Messages.stacksToDelete_error(stackName));
                }
            }
        }
        catch (Exception e) {
            cLog.logError(Messages.stacksToDelete_failed() + ExceptionUtils.getStackTrace(e));
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public String getDisplayName() {
            return "Delete HOT player stacks when build done";
        }
    }
}

