/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.slaveopts;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.SlaveOptions;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public abstract class LauncherFactory
extends AbstractDescribableImpl<LauncherFactory>
implements Serializable {
    private static final long serialVersionUID = -8322868020681278525L;
    private static final Logger LOGGER = Logger.getLogger(LauncherFactory.class.getName());

    public abstract ComputerLauncher createLauncher(@Nonnull JCloudsSlave var1) throws IOException;

    @CheckForNull
    public abstract String isWaitingFor(@Nonnull JCloudsSlave var1) throws JCloudsCloud.ProvisioningFailedException;

    public static final class Unspecified
    extends LauncherFactory {
        private Unspecified() {
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            throw new UnsupportedOperationException();
        }

        @Extension(ordinal=1.7976931348623157E308)
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            @Nonnull
            public String getDisplayName() {
                return "Inherit / Override later";
            }

            public LauncherFactory newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
                return null;
            }
        }
    }

    public static final class JNLP
    extends LauncherFactory {
        private static final long serialVersionUID = -1112849796889317240L;
        public static final LauncherFactory JNLP = new JNLP();

        private JNLP() {
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) throws IOException {
            Jenkins.getActiveInstance().addNode((Node)slave);
            return new JNLPLauncher();
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            return slave.getChannel() != null ? null : "JNLP connection was not established yet";
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        private Object readResolve() {
            return JNLP;
        }

        @Extension
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            public LauncherFactory newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
                return JNLP;
            }
        }
    }

    public static final class SSH
    extends LauncherFactory {
        private static final long serialVersionUID = -1108865485314632255L;
        private final String credentialsId;
        private final String javaPath;

        public String getCredentialsId() {
            return this.credentialsId;
        }

        public String getJavaPath() {
            return this.javaPath;
        }

        @DataBoundConstructor
        public SSH(String credentialsId, String javaPath) {
            this.credentialsId = credentialsId;
            this.javaPath = Util.fixEmptyAndTrim((String)javaPath);
        }

        public SSH(String credentialsId) {
            this(credentialsId, null);
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) throws IOException {
            int maxNumRetries = 5;
            int retryWaitTime = 15;
            if (this.credentialsId == null) {
                throw new JCloudsCloud.ProvisioningFailedException("No ssh credentials specified for " + slave.getNodeName());
            }
            String publicAddress = slave.getPublicAddressIpv4();
            SlaveOptions opts = slave.getSlaveOptions();
            Integer timeout = opts.getStartTimeout();
            timeout = timeout == null ? 0 : timeout / 1000;
            return new SSHLauncher(publicAddress, 22, this.credentialsId, opts.getJvmOptions(), this.javaPath, "", "", timeout, Integer.valueOf(maxNumRetries), Integer.valueOf(retryWaitTime));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SSH ssh = (SSH)o;
            return Objects.equals(this.credentialsId, ssh.credentialsId) && Objects.equals(this.javaPath, ssh.javaPath);
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.javaPath);
        }

        public String toString() {
            return "LauncherFactory.SSH: credId:" + this.credentialsId + ", javaPath:" + this.javaPath;
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            String publicAddress;
            try {
                publicAddress = slave.getPublicAddressIpv4();
            }
            catch (NoSuchElementException ex) {
                throw new JCloudsCloud.ProvisioningFailedException(ex.getMessage(), ex);
            }
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(publicAddress, 22), 500);
                socket.close();
                return null;
            }
            catch (ConnectException | NoRouteToHostException | SocketTimeoutException ex) {
                String msg = "SSH port at " + publicAddress + " not open (yet)";
                LOGGER.log(Level.FINEST, msg, ex);
                return msg;
            }
            catch (IOException ex) {
                String msg = "SSH port at " + publicAddress + " does not seem to respond correctly: " + ex.getMessage();
                LOGGER.log(Level.INFO, msg, ex);
                return msg;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "SSH probe failed", ex);
                return null;
            }
        }

        @Extension
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            @Restricted(value={DoNotUse.class})
            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
                if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getActiveInstance()).hasPermission(Computer.CONFIGURE)) {
                    return new ListBoxModel();
                }
                List credentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME});
                return new StandardUsernameListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)credentials).withEmptySelection();
            }
        }
    }
}

