/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.remoting.Base64;
import hudson.slaves.OfflineCause;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.UserDataConfig;
import jenkins.plugins.openstack.compute.UserDataVariableResolver;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.slaveopts.BootSource;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.openstack4j.api.Builders;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;

public class JCloudsSlaveTemplate
implements Describable<JCloudsSlaveTemplate>,
SlaveOptions.Holder {
    public static final String OPENSTACK_CLOUD_NAME_KEY = "jenkins-cloud-name";
    public static final String OPENSTACK_TEMPLATE_NAME_KEY = "jenkins-template-name";
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlaveTemplate.class.getName());
    private static final char SEPARATOR_CHAR = ',';
    private static final AtomicInteger nodeCounter = new AtomicInteger();
    public final String name;
    public final String labelString;
    private SlaveOptions slaveOptions;
    private transient Set<LabelAtom> labelSet;
    private transient JCloudsCloud cloud;
    @Deprecated
    private transient String imageId;
    @Deprecated
    private transient String hardwareId;
    @Deprecated
    private transient String userDataId;
    @Deprecated
    private transient String numExecutors;
    @Deprecated
    private transient String jvmOptions;
    @Deprecated
    private transient String fsRoot;
    @Deprecated
    private transient Integer overrideRetentionTime;
    @Deprecated
    private transient String keyPairName;
    @Deprecated
    private transient String networkId;
    @Deprecated
    private transient String securityGroups;
    @Deprecated
    private transient String credentialsId;
    @Deprecated
    private transient String slaveType;
    @Deprecated
    private transient String availabilityZone;

    @DataBoundConstructor
    public JCloudsSlaveTemplate(String name, String labelString, SlaveOptions slaveOptions) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.labelString = Util.fixNull((String)labelString);
        this.slaveOptions = slaveOptions;
        this.readResolve();
    }

    private Object readResolve() {
        LauncherFactory lf;
        int i;
        this.labelSet = Label.parse((String)this.labelString);
        if (this.hardwareId != null && (i = this.hardwareId.indexOf(47)) != -1) {
            this.hardwareId = this.hardwareId.substring(i + 1);
        }
        if (this.networkId != null && (i = this.networkId.indexOf(47)) != -1) {
            this.networkId = this.networkId.substring(i + 1);
        }
        if (this.imageId != null && (i = this.imageId.indexOf(47)) != -1) {
            this.imageId = this.imageId.substring(i + 1);
        }
        if (this.slaveOptions == null) {
            lf = null;
            if ("SSH".equals(this.slaveType) || this.credentialsId != null) {
                lf = new LauncherFactory.SSH(this.credentialsId);
            } else if ("JNLP".equals(this.slaveType)) {
                lf = LauncherFactory.JNLP.JNLP;
            }
            this.slaveOptions = SlaveOptions.builder().bootSource(new BootSource.Image(this.imageId)).hardwareId(this.hardwareId).numExecutors(Integer.getInteger(this.numExecutors)).jvmOptions(this.jvmOptions).userDataId(this.userDataId).fsRoot(this.fsRoot).retentionTime(this.overrideRetentionTime).keyPairName(this.keyPairName).networkId(this.networkId).securityGroups(this.securityGroups).launcherFactory(lf).availabilityZone(this.availabilityZone).build();
            this.hardwareId = null;
            this.numExecutors = null;
            this.jvmOptions = null;
            this.userDataId = null;
            this.fsRoot = null;
            this.overrideRetentionTime = null;
            this.keyPairName = null;
            this.networkId = null;
            this.securityGroups = null;
            this.credentialsId = null;
            this.slaveType = null;
            this.availabilityZone = null;
        }
        if (this.slaveOptions.slaveType != null) {
            lf = null;
            if ("JNLP".equals(this.slaveOptions.slaveType)) {
                lf = LauncherFactory.JNLP.JNLP;
                this.slaveOptions.slaveType = null;
            } else if ("SSH".equals(this.slaveOptions.slaveType)) {
                lf = new LauncherFactory.SSH(this.slaveOptions.credentialsId);
                this.slaveOptions.credentialsId = null;
                this.slaveOptions.slaveType = null;
            }
            if (lf != null) {
                this.slaveOptions = this.slaveOptions.getBuilder().launcherFactory(lf).build();
            }
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    void setOwner(JCloudsCloud cloud) {
        this.cloud = cloud;
        this.slaveOptions = this.slaveOptions.eraseDefaults(cloud.getEffectiveSlaveOptions());
    }

    @Override
    @Nonnull
    public SlaveOptions getEffectiveSlaveOptions() {
        return this.cloud.getEffectiveSlaveOptions().override(this.slaveOptions);
    }

    @Override
    @Nonnull
    public SlaveOptions getRawSlaveOptions() {
        if (this.cloud == null) {
            throw new IllegalStateException("Owner not set properly");
        }
        return this.slaveOptions;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public boolean canProvision(Label label) {
        return label == null || label.matches(this.labelSet);
    }

    boolean hasProvisioned(@Nonnull Server server) {
        return this.name.equals(server.getMetadata().get(OPENSTACK_TEMPLATE_NAME_KEY));
    }

    @Nonnull
    public JCloudsSlave provisionSlave(@Nonnull JCloudsCloud cloud, @Nonnull ProvisioningActivity.Id id) throws JCloudsCloud.ProvisioningFailedException {
        SlaveOptions opts = this.getEffectiveSlaveOptions();
        int timeout = opts.getStartTimeout();
        Server nodeMetadata = this.provision(cloud);
        JCloudsSlave node = null;
        try {
            String cause;
            node = new JCloudsSlave(id, nodeMetadata, this.labelString, opts);
            while ((cause = cloud.slaveIsWaitingFor(node)) != null) {
                if (System.currentTimeMillis() - node.getCreatedTime() > (long)timeout) {
                    String timeoutMessage = String.format("Failed to connect agent %s within timeout (%d ms): %s", node.getNodeName(), timeout, cause);
                    Error errorQuerying = null;
                    try {
                        Server freshServer = cloud.getOpenstack().getServerById(nodeMetadata.getId());
                        timeoutMessage = timeoutMessage + System.lineSeparator() + "Server state: " + freshServer;
                    }
                    catch (NoSuchElementException ex) {
                        timeoutMessage = timeoutMessage + System.lineSeparator() + "Server does no longer exist: " + nodeMetadata.getId();
                    }
                    catch (Error ex) {
                        errorQuerying = ex;
                    }
                    LOGGER.warning(timeoutMessage);
                    JCloudsCloud.ProvisioningFailedException ex = new JCloudsCloud.ProvisioningFailedException(timeoutMessage);
                    if (errorQuerying != null) {
                        ex.addSuppressed(errorQuerying);
                    }
                    throw ex;
                }
                Thread.sleep(2000L);
            }
            return node;
        }
        catch (Throwable ex) {
            JCloudsCloud.ProvisioningFailedException cause;
            JCloudsCloud.ProvisioningFailedException provisioningFailedException = cause = ex instanceof JCloudsCloud.ProvisioningFailedException ? (JCloudsCloud.ProvisioningFailedException)ex : new JCloudsCloud.ProvisioningFailedException("Unable to provision node: " + ex.getMessage(), ex);
            if (node != null) {
                node._terminate(TaskListener.NULL);
            }
            throw cause;
        }
    }

    @Nonnull
    Server provision(@Nonnull JCloudsCloud cloud) throws Openstack.ActionFailed {
        return this.provision(cloud, null);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Server provision(@Nonnull JCloudsCloud cloud, @CheckForNull ServerScope scope) throws Openstack.ActionFailed {
        String userDataText;
        String az;
        String kpn;
        String securityGroups;
        String nid;
        String serverName = this.getServerName();
        SlaveOptions opts = this.getEffectiveSlaveOptions();
        ServerCreateBuilder builder = Builders.server();
        builder.addMetadataItem(OPENSTACK_TEMPLATE_NAME_KEY, this.name);
        builder.addMetadataItem(OPENSTACK_CLOUD_NAME_KEY, cloud.name);
        if (scope == null) {
            scope = new ServerScope.Node(serverName);
        }
        builder.addMetadataItem("jenkins-scope", scope.getValue());
        LOGGER.info("Provisioning new openstack server " + serverName + " with options " + opts);
        builder.name(serverName);
        Openstack openstack = cloud.getOpenstack();
        BootSource bootSource = opts.getBootSource();
        if (bootSource == null) {
            LOGGER.warning("No " + BootSource.class.getSimpleName() + " set for " + this.getClass().getSimpleName() + " with name='" + this.name + "'.");
        } else {
            LOGGER.fine("Setting boot options to " + bootSource);
            bootSource.setServerBootSource(builder, openstack);
        }
        String hwid = opts.getHardwareId();
        if (!Strings.isNullOrEmpty((String)hwid)) {
            LOGGER.fine("Setting hardware Id to " + hwid);
            builder.flavor(hwid);
        }
        if (!Strings.isNullOrEmpty((String)(nid = opts.getNetworkId()))) {
            List<String> networks = openstack.getNetworkIds(Arrays.asList(JCloudsSlaveTemplate.csvToArray(nid)));
            LOGGER.fine("Setting networks to " + networks);
            builder.networks(networks);
        }
        if (!Strings.isNullOrEmpty((String)(securityGroups = opts.getSecurityGroups()))) {
            LOGGER.fine("Setting security groups to " + securityGroups);
            for (String sg : JCloudsSlaveTemplate.csvToArray(securityGroups)) {
                builder.addSecurityGroup(sg);
            }
        }
        if (!Strings.isNullOrEmpty((String)(kpn = opts.getKeyPairName()))) {
            LOGGER.fine("Setting keyPairName to " + kpn);
            builder.keypairName(kpn);
        }
        if (!Strings.isNullOrEmpty((String)(az = opts.getAvailabilityZone()))) {
            LOGGER.fine("Setting availabilityZone to " + az);
            builder.availabilityZone(az);
        }
        if ((userDataText = this.getUserData()) != null) {
            String rootUrl = Jenkins.getActiveInstance().getRootUrl();
            UserDataVariableResolver resolver = new UserDataVariableResolver(rootUrl, serverName, this.labelString, opts);
            String content = Util.replaceMacro((String)userDataText, (VariableResolver)resolver);
            LOGGER.fine("Sending user-data:\n" + content);
            builder.userData(Base64.encode((byte[])content.getBytes(Charsets.UTF_8)));
        }
        Server server = openstack.bootAndWaitActive(builder, opts.getStartTimeout());
        try {
            String poolName;
            if (bootSource != null) {
                bootSource.afterProvisioning(server, openstack);
            }
            if ((poolName = opts.getFloatingIpPool()) != null) {
                LOGGER.fine("Assigning floating IP from " + poolName + " to " + serverName);
                openstack.assignFloatingIp(server, poolName);
                server = openstack.updateInfo(server);
                LOGGER.info("Amended server: " + server.toString());
            }
            LOGGER.info("Provisioned: " + server.toString());
            return server;
        }
        catch (Throwable ex) {
            AsyncResourceDisposer.get().dispose(new Disposable[]{new DestroyMachine(cloud.name, server.getId())});
            throw ex;
        }
    }

    private String getServerName() {
        String nameCandidate;
        CloudStatistics cs = CloudStatistics.get();
        block0: while (true) {
            nameCandidate = this.name + "-" + nodeCounter.getAndIncrement();
            if (Jenkins.getInstance().getNode(nameCandidate) != null) continue;
            for (ProvisioningActivity provisioningActivity : cs.getActivities()) {
                if (!nameCandidate.equals(provisioningActivity.getId().getNodeName())) continue;
                continue block0;
            }
            break;
        }
        return nameCandidate;
    }

    @Nonnull
    private static String[] csvToArray(String csv) {
        try {
            CSVReader reader = new CSVReader((Reader)new StringReader(csv), ',');
            String[] line = reader.readNext();
            return line != null ? line : new String[]{};
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @CheckForNull
    String getUserData() {
        UserDataConfig.UserDataConfigProvider userDataConfigProvider = (UserDataConfig.UserDataConfigProvider)((Object)ConfigProvider.all().get(UserDataConfig.UserDataConfigProvider.class));
        if (userDataConfigProvider == null) {
            throw new AssertionError((Object)"Openstack Config File Provider is not registered");
        }
        Config userData = userDataConfigProvider.getConfigById(this.getEffectiveSlaveOptions().getUserDataId());
        return userData == null || userData.content.isEmpty() ? null : userData.content;
    }

    List<? extends Server> getRunningNodes() {
        ArrayList<Server> tmplt = new ArrayList<Server>();
        for (Server server : this.cloud.getOpenstack().getRunningNodes()) {
            Map md = server.getMetadata();
            if (!this.name.equals(md.get(OPENSTACK_TEMPLATE_NAME_KEY))) continue;
            tmplt.add(server);
        }
        return tmplt;
    }

    public int getActiveNodesTotal(boolean onlyNewComputers) {
        int totalServers = 0;
        for (Node node : Jenkins.getActiveInstance().getNodes()) {
            JCloudsComputer computer;
            JCloudsSlave slave;
            if (!(node instanceof JCloudsSlave) || !(slave = (JCloudsSlave)node).getId().getCloudName().equals(this.cloud.name) || !slave.getId().getTemplateName().equals(this.name) || (computer = (JCloudsComputer)slave.toComputer()) == null || computer.isPendingDelete() || computer.getOfflineCause() instanceof OfflineCause.UserCause) continue;
            if (onlyNewComputers) {
                if (computer.isUsed()) continue;
                ++totalServers;
                continue;
            }
            ++totalServers;
        }
        return totalServers;
    }

    public Descriptor<JCloudsSlaveTemplate> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JCloudsSlaveTemplate> {
        private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9][-a-zA-Z0-9]{0,79}$");

        public String getDisplayName() {
            return this.clazz.getSimpleName();
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckName(@QueryParameter String value) {
            if (NAME_PATTERN.matcher(value).find()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Must be a lowercase string, from 1 to 80 characteres long, starting with letter or number");
        }
    }
}

