/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.Messages;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerResponse;

public class JCloudsComputer
extends AbstractCloudComputer<JCloudsSlave>
implements TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(JCloudsComputer.class.getName());
    private final ProvisioningActivity.Id provisioningId;
    private boolean used;
    private static final PendingTermination PENDING_TERMINATION = new PendingTermination();

    @Nonnull
    public static List<JCloudsComputer> getAll() {
        ArrayList<JCloudsComputer> out = new ArrayList<JCloudsComputer>();
        for (Computer c : Jenkins.getActiveInstance().getComputers()) {
            if (!(c instanceof JCloudsComputer)) continue;
            out.add((JCloudsComputer)c);
        }
        return out;
    }

    public JCloudsComputer(JCloudsSlave slave) {
        super((AbstractCloudSlave)slave);
        this.provisioningId = slave.getId();
        this.used = false;
    }

    @CheckForNull
    public JCloudsSlave getNode() {
        return (JCloudsSlave)super.getNode();
    }

    @Nonnull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public void setPendingDelete(boolean newVal) {
        boolean is = this.isPendingDelete();
        if (is == newVal) {
            return;
        }
        LOGGER.info("Setting " + this.getName() + " pending delete status to " + newVal);
        this.setTemporarilyOffline(newVal, (OfflineCause)(newVal ? PENDING_TERMINATION : null));
    }

    public boolean isPendingDelete() {
        return this.offlineCause instanceof PendingTermination;
    }

    @CheckForNull
    OfflineCause getFatalOfflineCause() {
        OfflineCause oc = this.getOfflineCause();
        return oc instanceof DiskSpaceMonitorDescriptor.DiskSpace || oc instanceof OfflineCause.ChannelTermination ? oc : null;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        this.used = true;
    }

    public boolean isUsed() {
        return this.used;
    }

    @Restricted(value={DoNotUse.class})
    public void doConfigure(StaplerResponse rsp) throws IOException {
        rsp.sendError(404);
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doDoDelete() {
        this.checkPermission(Permission.DELETE);
        try {
            this.deleteSlave();
            return new HttpRedirect("..");
        }
        catch (Exception ex) {
            return HttpResponses.error((int)500, (Throwable)ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public HttpRedirect doScheduleTermination() {
        this.checkPermission(Permission.DELETE);
        this.setPendingDelete(true);
        return new HttpRedirect(".");
    }

    void deleteSlave() throws IOException, InterruptedException {
        JCloudsSlave slave = this.getNode();
        if (slave == null) {
            return;
        }
        LOGGER.info("Deleting slave " + this.getName());
        this.setAcceptingTasks(false);
        try {
            slave.terminate();
            LOGGER.info("Deleted slave " + this.getName());
        }
        catch (Throwable ex) {
            this.setAcceptingTasks(true);
            throw ex;
        }
    }

    private static final class PendingTermination
    extends OfflineCause.SimpleOfflineCause {
        private PendingTermination() {
            super(Messages._DeletedCause());
        }
    }
}

