/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.Objects;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.auth.AbstractOpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentials;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentialv2;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentialv3;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.openstack4j.model.compute.Server;

public class JCloudsCloud
extends Cloud
implements SlaveOptions.Holder {
    private static final Logger LOGGER = Logger.getLogger(JCloudsCloud.class.getName());
    private String credentialId;
    @Nonnull
    public final String endPointUrl;
    private boolean ignoreSsl;
    @CheckForNull
    public final String zone;
    @Nonnull
    private final List<JCloudsSlaveTemplate> templates;
    @Nonnull
    private SlaveOptions slaveOptions;
    @Deprecated
    private transient Integer instanceCap;
    @Deprecated
    private transient Integer retentionTime;
    @Deprecated
    private transient Integer startTimeout;
    @Deprecated
    private transient Boolean floatingIps;
    @Deprecated
    private transient String identity;
    @Deprecated
    private transient Secret credential;

    @Nonnull
    public static List<JCloudsCloud> getClouds() {
        ArrayList<JCloudsCloud> clouds = new ArrayList<JCloudsCloud>();
        for (Cloud c : Jenkins.getActiveInstance().clouds) {
            if (!JCloudsCloud.class.isInstance(c)) continue;
            clouds.add((JCloudsCloud)c);
        }
        return clouds;
    }

    @Nonnull
    public static JCloudsCloud getByName(@Nonnull String name) throws IllegalArgumentException {
        Cloud cloud = Jenkins.getActiveInstance().clouds.getByName(name);
        if (cloud instanceof JCloudsCloud) {
            return (JCloudsCloud)cloud;
        }
        throw new IllegalArgumentException("'" + name + "' is not an OpenStack cloud but " + cloud);
    }

    @DataBoundConstructor
    @Restricted(value={DoNotUse.class})
    public JCloudsCloud(String name, String endPointUrl, boolean ignoreSsl, String zone, SlaveOptions slaveOptions, List<JCloudsSlaveTemplate> templates, String credentialId) {
        super(Util.fixNull((String)name).trim());
        this.endPointUrl = Util.fixNull((String)endPointUrl).trim();
        this.ignoreSsl = ignoreSsl;
        this.zone = Util.fixEmptyAndTrim((String)zone);
        this.credentialId = credentialId;
        this.slaveOptions = slaveOptions.eraseDefaults(DescriptorImpl.DEFAULTS);
        this.templates = Collections.unmodifiableList((List)Objects.firstNonNull(templates, Collections.emptyList()));
        this.injectReferenceIntoTemplates();
    }

    private Object readResolve() {
        if (this.retentionTime != null || this.startTimeout != null || this.floatingIps != null || this.instanceCap != null) {
            SlaveOptions carry = SlaveOptions.builder().instanceCap(this.instanceCap).retentionTime(this.retentionTime).startTimeout(this.startTimeout).floatingIpPool(this.floatingIps != false ? "public" : null).build();
            this.slaveOptions = DescriptorImpl.DEFAULTS.override(carry);
            this.retentionTime = null;
            this.startTimeout = null;
            this.floatingIps = null;
            this.instanceCap = null;
        }
        LauncherFactory lf = null;
        if ("JNLP".equals(this.slaveOptions.slaveType)) {
            lf = LauncherFactory.JNLP.JNLP;
        } else if (!"JNLP".equals(this.slaveOptions.slaveType) && this.slaveOptions.credentialsId != null) {
            lf = new LauncherFactory.SSH(this.slaveOptions.credentialsId);
        }
        if (lf != null) {
            this.slaveOptions = this.slaveOptions.getBuilder().launcherFactory(lf).build();
        }
        this.injectReferenceIntoTemplates();
        if (this.identity != null) {
            String[] id = this.identity.split(":");
            AbstractOpenstackCredential migratedOpenstackCredential = null;
            if (id.length == 2) {
                String tenant = id.length > 0 ? id[0] : "";
                String username = id.length > 1 ? id[1] : "";
                migratedOpenstackCredential = new OpenstackCredentialv2(CredentialsScope.SYSTEM, null, null, tenant, username, this.credential);
            } else if (id.length == 3) {
                String project = id[0];
                String username = id[1];
                String domain = id[2];
                migratedOpenstackCredential = new OpenstackCredentialv3(CredentialsScope.SYSTEM, null, null, username, domain, project, domain, this.credential);
            }
            if (migratedOpenstackCredential != null) {
                this.credentialId = migratedOpenstackCredential.getId();
                try {
                    OpenstackCredentials.add(migratedOpenstackCredential);
                    OpenstackCredentials.save();
                    this.identity = null;
                    this.credential = null;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Unable to migrate " + this.name + " cloud credential to the new version", e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Unable to migrate " + this.name + " cloud credential to the new version");
            }
        }
        return this;
    }

    private void injectReferenceIntoTemplates() {
        for (JCloudsSlaveTemplate t : this.templates) {
            t.setOwner(this);
        }
    }

    @Override
    @Nonnull
    public SlaveOptions getEffectiveSlaveOptions() {
        return DescriptorImpl.DEFAULTS.override(this.slaveOptions);
    }

    @Override
    @Nonnull
    public SlaveOptions getRawSlaveOptions() {
        return this.slaveOptions;
    }

    @Nonnull
    public List<JCloudsSlaveTemplate> getTemplates() {
        return this.templates;
    }

    @CheckForNull
    private Queue<JCloudsSlaveTemplate> getAvailableTemplateProvider(@CheckForNull Label label) {
        String labelString = label != null ? label.toString() : "none";
        List<Server> runningNodes = this.getOpenstack().getRunningNodes();
        int globalMax = this.getEffectiveSlaveOptions().getInstanceCap();
        ConcurrentLinkedDeque<JCloudsSlaveTemplate> queue = new ConcurrentLinkedDeque<JCloudsSlaveTemplate>();
        int globalCapacity = globalMax - runningNodes.size();
        if (globalCapacity <= 0) {
            LOGGER.log(Level.INFO, "Global instance cap ({0}) reached while adding capacity for label: {1}", new Object[]{globalMax, labelString});
            return queue;
        }
        LinkedHashMap<JCloudsSlaveTemplate, Integer> template2capacity = new LinkedHashMap<JCloudsSlaveTemplate, Integer>();
        for (JCloudsSlaveTemplate jCloudsSlaveTemplate : this.templates) {
            int templateMax;
            if (!jCloudsSlaveTemplate.canProvision(label)) continue;
            int templateCapacity = templateMax = jCloudsSlaveTemplate.getEffectiveSlaveOptions().getInstanceCap().intValue();
            for (Server server : runningNodes) {
                if (!jCloudsSlaveTemplate.hasProvisioned(server)) continue;
                --templateCapacity;
            }
            if (templateCapacity > 0) {
                template2capacity.put(jCloudsSlaveTemplate, templateCapacity);
                continue;
            }
            LOGGER.log(Level.INFO, "Template instance cap for {0} ({1}) reached while adding capacity for label: {2}", new Object[]{jCloudsSlaveTemplate.name, templateMax, labelString});
        }
        block2: for (Map.Entry entry : template2capacity.entrySet()) {
            for (int i = ((Integer)entry.getValue()).intValue(); i > 0; --i) {
                if (globalCapacity > 0) {
                    queue.add((JCloudsSlaveTemplate)entry.getKey());
                    --globalCapacity;
                    continue;
                }
                LOGGER.log(Level.INFO, "Global instance cap ({0}) reached while adding capacity for label: {1}", new Object[]{globalMax, labelString});
                break block2;
            }
        }
        return queue;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        Queue<JCloudsSlaveTemplate> templateProvider = this.getAvailableTemplateProvider(label);
        ArrayList<NodeProvisioner.PlannedNode> plannedNodeList = new ArrayList<NodeProvisioner.PlannedNode>();
        while (excessWorkload > 0 && !Jenkins.getActiveInstance().isQuietingDown() && !Jenkins.getActiveInstance().isTerminating()) {
            JCloudsSlaveTemplate template = templateProvider.poll();
            if (template == null) {
                LOGGER.info("Instance cap exceeded on all available templates");
                break;
            }
            LOGGER.fine("Provisioning slave for " + label + " from template " + template.name);
            int numExecutors = template.getEffectiveSlaveOptions().getNumExecutors();
            ProvisioningActivity.Id id = new ProvisioningActivity.Id(this.name, template.name);
            Future<Node> task = Computer.threadPoolForRemoting.submit(new NodeCallable(this, template, id));
            plannedNodeList.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(id, numExecutors, task));
            excessWorkload -= numExecutors;
        }
        return plannedNodeList;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public String slaveIsWaitingFor(@Nonnull JCloudsSlave slave) throws ProvisioningFailedException {
        return slave.getSlaveOptions().getLauncherFactory().isWaitingFor(slave);
    }

    public boolean canProvision(Label label) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.canProvision(label)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public JCloudsSlaveTemplate getTemplate(String name) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name) throws ServletException, IOException, Descriptor.FormException, InterruptedException {
        Object node2;
        int globalCap;
        if (!this.hasPermission(Item.CONFIGURE) && !this.hasPermission(Cloud.PROVISION)) {
            this.checkPermission(Cloud.PROVISION);
        }
        if (name == null) {
            this.sendError("The slave template name query parameter is missing", req, rsp);
            return;
        }
        JCloudsSlaveTemplate t = this.getTemplate(name);
        if (t == null) {
            this.sendError("No such slave template with name : " + name, req, rsp);
            return;
        }
        List<Server> nodes = this.getOpenstack().getRunningNodes();
        int global = nodes.size();
        if (global >= (globalCap = this.getEffectiveSlaveOptions().getInstanceCap().intValue())) {
            String msg = String.format("Instance cap of %s is now reached: %d", this.name, globalCap);
            this.sendError(msg, req, rsp);
            return;
        }
        int template = 0;
        for (Object node2 : nodes) {
            if (!t.hasProvisioned((Server)node2)) continue;
            ++template;
        }
        int templateCap = t.getEffectiveSlaveOptions().getInstanceCap();
        if (template >= templateCap) {
            String msg = String.format("Instance cap for this template (%s/%s) is now reached: %d", this.name, name, templateCap);
            this.sendError(msg, req, rsp);
            return;
        }
        try {
            node2 = this.provisionSlave(t);
        }
        catch (Openstack.ActionFailed ex) {
            req.setAttribute("message", (Object)ex.getMessage());
            req.setAttribute("exception", (Object)ex);
            rsp.forward((Object)this, "error", req);
            return;
        }
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node2.getNodeName());
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public JCloudsSlave provisionSlave(JCloudsSlaveTemplate template) throws IOException, Openstack.ActionFailed {
        JCloudsSlave node;
        CloudStatistics.ProvisioningListener provisioningListener = CloudStatistics.ProvisioningListener.get();
        ProvisioningActivity.Id id = new ProvisioningActivity.Id(this.name, template.name);
        try {
            provisioningListener.onStarted(id);
            node = template.provisionSlave(this, id);
            provisioningListener.onComplete(id, (Node)node);
        }
        catch (Openstack.ActionFailed ex) {
            provisioningListener.onFailure(id, (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            provisioningListener.onFailure(id, ex);
            throw ex;
        }
        Jenkins.getActiveInstance().addNode((Node)node);
        return node;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Openstack getOpenstack() {
        Openstack os;
        try {
            os = Openstack.Factory.get(this.endPointUrl, this.ignoreSsl, OpenstackCredentials.getCredential(this.credentialId), this.zone);
        }
        catch (FormValidation ex) {
            LOGGER.log(Level.SEVERE, "Openstack authentication invalid", ex);
            throw new RuntimeException("Openstack authentication invalid", ex);
        }
        return os;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public boolean getIgnoreSsl() {
        return this.ignoreSsl;
    }

    public static final class ProvisioningFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -8524954909721965323L;

        public ProvisioningFailedException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public ProvisioningFailedException(String msg) {
            super(msg);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final SlaveOptions DEFAULTS = SlaveOptions.builder().instanceCap(10).instancesMin(0).retentionTime(30).startTimeout(600000).numExecutors(1).fsRoot("/jenkins").securityGroups("default").build();

        @Nonnull
        public String getDisplayName() {
            return "Cloud (OpenStack)";
        }

        public static SlaveOptions getDefaultOptions() {
            return DEFAULTS;
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter boolean ignoreSsl, @QueryParameter String credentialId, @QueryParameter String endPointUrl, @QueryParameter String zone) {
            try {
                OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialId);
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                Throwable ex = openstack.sanityCheck();
                if (ex != null) {
                    return FormValidation.warning((Throwable)ex, (String)("Connection not validated, plugin might not operate correctly: " + ex.getMessage()));
                }
                return FormValidation.okWithMarkup((String)("Connection succeeded!<br/><small>" + Util.escape((String)openstack.getInfo()) + "</small>"));
            }
            catch (FormValidation ex) {
                return ex;
            }
            catch (Exception ex) {
                return FormValidation.error((Throwable)ex, (String)("Cannot connect to specified cloud, please check the identity and credentials: " + ex.getMessage()));
            }
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckEndPointUrl(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.validateRequired((String)value);
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException ex) {
                return FormValidation.error((Throwable)ex, (String)"The endpoint must be URL");
            }
            return FormValidation.ok();
        }

        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Jenkins context) {
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(OpenstackCredential.class), (Iterable)credentials);
        }
    }

    private static final class NodeCallable
    implements Callable<Node> {
        private final JCloudsCloud cloud;
        private final JCloudsSlaveTemplate template;
        private final ProvisioningActivity.Id id;

        NodeCallable(JCloudsCloud cloud, JCloudsSlaveTemplate template, ProvisioningActivity.Id id) {
            this.cloud = cloud;
            this.template = template;
            this.id = id;
        }

        @Override
        public Node call() {
            JCloudsSlave jcloudsSlave = this.template.provisionSlave(this.cloud, this.id);
            LOGGER.fine(String.format("Slave %s launched successfully", jcloudsSlave.getDisplayName()));
            return jcloudsSlave;
        }
    }
}

