/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Hudson;
import hudson.plugins.openid.Identity;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenIdExtension
implements ExtensionPoint {
    public abstract void extend(AuthRequest var1) throws MessageException;

    public abstract void process(AuthSuccess var1, Identity var2) throws MessageException;

    public void extendFetch(FetchRequest request) throws MessageException {
    }

    protected <T> T getMessageAs(Class<T> c, AuthSuccess authSuccess, String typeUri) throws MessageException {
        MessageExtension me = authSuccess.getExtension(typeUri);
        return c.cast(me);
    }

    public static ExtensionList<OpenIdExtension> all() {
        return Hudson.getInstance().getExtensionList(OpenIdExtension.class);
    }

    public static void extendRequest(AuthRequest authRequest) throws MessageException {
        FetchRequest request = FetchRequest.createFetchRequest();
        for (OpenIdExtension e : OpenIdExtension.all()) {
            e.extend(authRequest);
            e.extendFetch(request);
        }
        authRequest.addExtension((MessageExtension)request);
    }

    public static void processResponse(AuthSuccess authSuccess, Identity id) throws MessageException {
        for (OpenIdExtension e : OpenIdExtension.all()) {
            e.process(authSuccess, id);
        }
    }
}

