/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openstf.axis;

import hudson.Extension;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.model.Descriptor;
import hudson.plugins.openstf.STFBuildWrapper;
import hudson.plugins.openstf.util.Utils;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class STFDeviceConditionAxis
extends Axis {
    public String type;

    @DataBoundConstructor
    public STFDeviceConditionAxis(String name, String type, List<String> values) {
        super(name, values);
        this.type = type;
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public DescriptorImpl() {
            super(STFDeviceConditionAxis.class);
            this.load();
        }

        public Axis newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String name = formData.getString("name");
            String type = formData.getString("type");
            List values = JSONArray.toList((JSONArray)formData.getJSONArray("values"), String.class);
            return new STFDeviceConditionAxis(name, type, values);
        }

        public String getDisplayName() {
            return "STF Device Condition";
        }

        public ListBoxModel doFillTypeItems() {
            Jenkins hudsonInstance = Jenkins.getInstance();
            STFBuildWrapper.DescriptorImpl descriptor = (STFBuildWrapper.DescriptorImpl)hudsonInstance.getDescriptorByType(STFBuildWrapper.DescriptorImpl.class);
            Utils.setupSTFApiClient(descriptor.stfApiEndpoint, descriptor.ignoreCertError, descriptor.stfToken);
            return Utils.getSTFDeviceAttributeListBoxItems();
        }

        public ListBoxModel doFillValuesItems(@QueryParameter String type) {
            Jenkins hudsonInstance = Jenkins.getInstance();
            STFBuildWrapper.DescriptorImpl descriptor = (STFBuildWrapper.DescriptorImpl)hudsonInstance.getDescriptorByType(STFBuildWrapper.DescriptorImpl.class);
            Utils.setupSTFApiClient(descriptor.stfApiEndpoint, descriptor.ignoreCertError, descriptor.stfToken);
            return Utils.getSTFDeviceAttributeValueListBoxItems(type);
        }
    }
}

