/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openstf;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.sdk.AndroidSdk;
import hudson.plugins.android_emulator.sdk.Tool;
import hudson.plugins.android_emulator.sdk.cli.SdkCliCommand;
import hudson.plugins.android_emulator.util.Utils;
import hudson.util.ArgumentListBuilder;
import hudson.util.NullStream;
import io.swagger.client.model.DeviceListResponseDevices;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jvnet.hudson.plugins.port_allocator.PortAllocationManager;

public class AndroidRemoteContext {
    public static final int ANDROID_COMMAND_TIMEOUT_MS = 60000;
    protected static final int PORT_RANGE_START = 5554;
    protected static final int PORT_RANGE_END = 9999;
    private int adbServerPort;
    protected String serial;
    protected PortAllocationManager portAllocator;
    private AndroidSdk sdk;
    private DeviceListResponseDevices stfDevice = null;
    protected AbstractBuild<?, ?> build;
    private BuildListener listener;
    protected Launcher launcher;

    public AndroidRemoteContext(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, AndroidSdk sdk) throws InterruptedException, IOException {
        this.build = build;
        this.listener = listener;
        this.launcher = launcher;
        this.sdk = sdk;
        Computer computer = Computer.currentComputer();
        this.portAllocator = PortAllocationManager.getManager((Computer)computer);
        int[] ports = this.portAllocator.allocatePortRange(this.build, 5554, 9999, 1, true);
        this.adbServerPort = ports[0];
    }

    public void cleanUp() {
        this.portAllocator.free(this.adbServerPort);
    }

    public int adbServerPort() {
        return this.adbServerPort;
    }

    public String serial() {
        return this.serial;
    }

    public BuildListener listener() {
        return this.listener;
    }

    public Launcher launcher() {
        return this.launcher;
    }

    public AndroidSdk sdk() {
        return this.sdk;
    }

    public PrintStream logger() {
        return this.listener.getLogger();
    }

    public Launcher.ProcStarter getProcStarter() throws IOException, InterruptedException {
        EnvVars buildEnvironment = this.build.getEnvironment(TaskListener.NULL);
        buildEnvironment.put("ANDROID_ADB_SERVER_PORT", Integer.toString(this.adbServerPort));
        if (this.sdk.hasKnownHome()) {
            buildEnvironment.put("ANDROID_SDK_HOME", this.sdk.getSdkHome());
        }
        if (this.launcher.isUnix()) {
            buildEnvironment.put("LD_LIBRARY_PATH", String.format("%s/tools/lib", this.sdk.getSdkRoot()));
        }
        return this.launcher.launch().stdout((OutputStream)new NullStream()).stderr((OutputStream)this.logger()).envs((Map)buildEnvironment);
    }

    public Launcher.ProcStarter getProcStarter(ArgumentListBuilder command) throws IOException, InterruptedException {
        return this.getProcStarter().cmds(command);
    }

    public ArgumentListBuilder getToolCommand(Tool tool, String args) {
        return Utils.getToolCommand((AndroidSdk)this.sdk, (boolean)this.launcher.isUnix(), (SdkCliCommand)new SdkCliCommand(tool, args));
    }

    public Launcher.ProcStarter getToolProcStarter(Tool tool, String args) throws IOException, InterruptedException {
        return this.getProcStarter(Utils.getToolCommand((AndroidSdk)this.sdk, (boolean)this.launcher.isUnix(), (SdkCliCommand)new SdkCliCommand(tool, args)));
    }

    public DeviceListResponseDevices getDevice() {
        return this.stfDevice;
    }

    public void setDevice(DeviceListResponseDevices device) {
        this.stfDevice = device;
        this.serial = device.remoteConnectUrl;
    }
}

