/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import com.cloudbees.workflow.rest.external.StatusExt;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class OntrackStepHelper {
    @Nullable
    public static String toValidationRunStatus(@Nullable Result result) {
        if (result == null || result.equals(Result.SUCCESS)) {
            return "PASSED";
        }
        if (result.equals(Result.UNSTABLE)) {
            return "WARNING";
        }
        if (result.equals(Result.FAILURE)) {
            return "FAILED";
        }
        if (result.equals(Result.ABORTED)) {
            return "INTERRUPTED";
        }
        return null;
    }

    public static String getValidationRunStatusFromStage(StepContext context) throws IOException, InterruptedException {
        FlowNode stage;
        FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
        if (flowNode != null && (stage = OntrackStepHelper.getStage(flowNode)) != null) {
            Result result = OntrackStepHelper.getStageStatusAsResult(stage);
            return OntrackStepHelper.toValidationRunStatus(result);
        }
        return OntrackStepHelper.getValidationRunStatusFromRun(context);
    }

    public static String getValidationRunStatusFromRun(StepContext context) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        if (run != null) {
            Result result = run.getResult();
            return OntrackStepHelper.toValidationRunStatus(result);
        }
        throw new IllegalStateException("Cannot get any status when not running in a build.");
    }

    @Nullable
    public static Map<String, ?> getRunInfo(StepContext context, TaskListener taskListener) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        if (run == null) {
            return null;
        }
        Map<String, Object> runInfo = OntrackPluginSupport.getRunInfo(run, taskListener);
        OntrackStepHelper.adaptRunInfo(context, runInfo);
        if (runInfo.isEmpty()) {
            return null;
        }
        return runInfo;
    }

    public static void adaptRunInfo(StepContext context, Map<String, Object> runInfo) {
        FlowNode flowNode = null;
        try {
            flowNode = (FlowNode)context.get(FlowNode.class);
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        if (flowNode != null) {
            Consumer<String> logger;
            boolean logging;
            OntrackConfiguration ontrackConfiguration = OntrackConfiguration.getOntrackConfiguration();
            boolean bl = logging = ontrackConfiguration != null && ontrackConfiguration.isOntrackTraceTimings();
            if (logging) {
                try {
                    TaskListener listener = (TaskListener)context.get(TaskListener.class);
                    if (listener != null) {
                        logger = message -> listener.getLogger().println((String)message);
                    }
                    logger = System.out::println;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Cannot get listener from context", ex);
                }
            } else {
                logger = message -> {};
            }
            Long durationMilliSeconds = OntrackStepHelper.getTiming(flowNode, logger);
            if (durationMilliSeconds != null) {
                runInfo.put("runTime", durationMilliSeconds / 1000L);
            }
        }
    }

    private static Long getTiming(FlowNode node, Consumer<String> logger) {
        BodyInvocationAction bodyInvocationAction;
        String stepDescriptorId;
        StepNode stepNode;
        StepDescriptor stepDescriptor;
        StepDescriptor descriptor;
        Long runTime = OntrackStepHelper.getExecutionTimeMs(node);
        String id = node.getId();
        if (node instanceof StepNode && (descriptor = ((StepNode)node).getDescriptor()) != null) {
            id = descriptor.getId();
        }
        logger.accept(String.format("[ontrack][timing]node=%s,type=%s,id=%s,runtTime=%d", node.getDisplayName(), node.getClass().getName(), id, runTime));
        if (node instanceof StepNode && (stepDescriptor = (stepNode = (StepNode)node).getDescriptor()) != null && ("org.jenkinsci.plugins.workflow.support.steps.StageStep".equals(stepDescriptorId = stepDescriptor.getId()) ? runTime != null : "org.jenkinsci.plugins.workflow.support.steps.ExecutorStep".equals(stepDescriptorId) && (bodyInvocationAction = (BodyInvocationAction)node.getAction(BodyInvocationAction.class)) != null && runTime != null)) {
            return runTime;
        }
        return OntrackStepHelper.getTiming(node.getParents(), logger);
    }

    @CheckForNull
    private static Long getExecutionTimeMs(FlowNode node) {
        TimingAction timingAction = (TimingAction)node.getAction(TimingAction.class);
        if (timingAction != null) {
            long startTime = timingAction.getStartTime();
            return System.currentTimeMillis() - startTime;
        }
        return null;
    }

    private static Long getTiming(List<FlowNode> nodes, Consumer<String> logger) {
        for (FlowNode node : nodes) {
            Long durationMilliSeconds = OntrackStepHelper.getTiming(node, logger);
            if (durationMilliSeconds == null) continue;
            return durationMilliSeconds;
        }
        return null;
    }

    private static Result getStageStatusAsResult(FlowNode node) {
        Result current = OntrackStepHelper.toResult(FlowNodeUtil.getStatus((FlowNode)node));
        List otherNodes = FlowNodeUtil.getStageNodes((FlowNode)node);
        for (FlowNode otherNode : otherNodes) {
            Result other = OntrackStepHelper.toResult(FlowNodeUtil.getStatus((FlowNode)otherNode));
            if (current != null && (other == null || !other.isWorseThan(current))) continue;
            current = other;
        }
        return current;
    }

    @Nullable
    private static Result toResult(StatusExt statusExt) {
        if (statusExt == null) {
            return null;
        }
        switch (statusExt) {
            case NOT_EXECUTED: {
                return null;
            }
            case ABORTED: {
                return Result.ABORTED;
            }
            case SUCCESS: {
                return Result.SUCCESS;
            }
            case IN_PROGRESS: {
                return Result.SUCCESS;
            }
            case PAUSED_PENDING_INPUT: {
                return null;
            }
            case FAILED: {
                return Result.FAILURE;
            }
            case UNSTABLE: {
                return Result.UNSTABLE;
            }
        }
        return null;
    }

    @Nullable
    private static FlowNode getStage(FlowNode node) {
        String stepDescriptorId;
        StepStartNode stepNode;
        StepDescriptor stepDescriptor;
        if (node instanceof StepStartNode && (stepDescriptor = (stepNode = (StepStartNode)node).getDescriptor()) != null && "org.jenkinsci.plugins.workflow.support.steps.StageStep".equals(stepDescriptorId = stepDescriptor.getId())) {
            return stepNode;
        }
        return OntrackStepHelper.getStage(node.getParents());
    }

    private static FlowNode getStage(List<FlowNode> nodes) {
        for (FlowNode node : nodes) {
            FlowNode stage = OntrackStepHelper.getStage(node);
            if (stage == null) continue;
            return stage;
        }
        return null;
    }
}

