/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.BranchFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ProjectFacade;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackBranchSetupStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String project;
    private final String branch;
    private final String script;
    private boolean logging = false;
    private Map<String, Object> bindings = Collections.emptyMap();

    @DataBoundConstructor
    public OntrackBranchSetupStep(String project, String branch, String script) {
        this.project = project;
        this.branch = branch;
        this.script = script;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    @DataBoundSetter
    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public boolean isLogging() {
        return this.logging;
    }

    @DataBoundSetter
    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.script)) {
            throw new AbortException("Ontrack branch setup not run. All mandatory properties must be supplied ('project', 'branch', 'script').");
        }
        return new SynchronousNonBlockingStepExecution<JSON>(context){

            protected JSON run() throws Exception {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                assert (listener != null);
                OntrackDSLFacade ontrack = OntrackDSLConnector.createOntrackConnector(listener);
                ProjectFacade ontrackProject = ontrack.project(OntrackBranchSetupStep.this.project);
                BranchFacade ontrackBranch = ontrackProject.branch(OntrackBranchSetupStep.this.branch, "", true);
                HashMap<String, Object> values = new HashMap<String, Object>(OntrackBranchSetupStep.this.bindings);
                values.put("ontrack", ontrack.getDSLRoot());
                values.put("branch", ontrackBranch.getDSLRoot());
                values.put("out", listener.getLogger());
                Binding binding = new Binding(values);
                GroovyShell shell = new GroovyShell(binding);
                listener.getLogger().format("[ontrack] Branch setup DSL script running...%n", new Object[0]);
                Object shellResult = shell.evaluate(OntrackBranchSetupStep.this.script);
                if (OntrackBranchSetupStep.this.logging) {
                    listener.getLogger().format("[ontrack] Branch setup DSL script returned result: %s%n", shellResult);
                } else {
                    listener.getLogger().format("[ontrack] Branch setup DSL script returned result.%n", new Object[0]);
                }
                return JSONSerializer.toJSON((Object)shellResult);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackBranchSetup";
        }

        @Nonnull
        public String getDisplayName() {
            return "Setup an Ontrack branch, and creates it if it does not exist.";
        }
    }
}

