/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl.v4;

import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.dsl.v4.ChangeLog;
import net.nemerosa.ontrack.jenkins.dsl.facade.BuildFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogCommitFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogFileFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogIssueFacade;
import net.nemerosa.ontrack.jenkins.dsl.v4.BuildV4Facade;
import net.nemerosa.ontrack.jenkins.dsl.v4.ChangeLogCommitV4Facade;
import net.nemerosa.ontrack.jenkins.dsl.v4.ChangeLogFileV4Facade;
import net.nemerosa.ontrack.jenkins.dsl.v4.ChangeLogIssueV4Facade;

public class ChangeLogV4Facade
implements ChangeLogFacade {
    private final ChangeLog changeLog;

    public ChangeLogV4Facade(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public BuildFacade getFrom() {
        return new BuildV4Facade(this.changeLog.getFrom());
    }

    @Override
    public BuildFacade getTo() {
        return new BuildV4Facade(this.changeLog.getTo());
    }

    @Override
    public List<ChangeLogCommitFacade> getCommits() {
        return this.changeLog.getCommits().stream().map(ChangeLogCommitV4Facade::new).collect(Collectors.toList());
    }

    @Override
    public List<ChangeLogIssueFacade> getIssues() {
        return this.changeLog.getIssues().stream().map(ChangeLogIssueV4Facade::new).collect(Collectors.toList());
    }

    @Override
    public List<ChangeLogFileFacade> getFiles() {
        return this.changeLog.getFiles().stream().map(ChangeLogFileV4Facade::new).collect(Collectors.toList());
    }

    @Override
    public String getPageLink() {
        return this.changeLog.link("page");
    }
}

