/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl.v3;

import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.dsl.ChangeLog;
import net.nemerosa.ontrack.jenkins.dsl.facade.BuildFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogCommitFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogFileFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ChangeLogIssueFacade;
import net.nemerosa.ontrack.jenkins.dsl.v3.BuildV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v3.ChangeLogCommitV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v3.ChangeLogFileV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v3.ChangeLogIssueV3Facade;

public class ChangeLogV3Facade
implements ChangeLogFacade {
    private final ChangeLog changeLog;

    public ChangeLogV3Facade(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public BuildFacade getFrom() {
        return new BuildV3Facade(this.changeLog.getFrom());
    }

    @Override
    public BuildFacade getTo() {
        return new BuildV3Facade(this.changeLog.getTo());
    }

    @Override
    public List<ChangeLogCommitFacade> getCommits() {
        return this.changeLog.getCommits().stream().map(ChangeLogCommitV3Facade::new).collect(Collectors.toList());
    }

    @Override
    public List<ChangeLogIssueFacade> getIssues() {
        return this.changeLog.getIssues().stream().map(ChangeLogIssueV3Facade::new).collect(Collectors.toList());
    }

    @Override
    public List<ChangeLogFileFacade> getFiles() {
        return this.changeLog.getFiles().stream().map(ChangeLogFileV3Facade::new).collect(Collectors.toList());
    }

    @Override
    public String getPageLink() {
        return this.changeLog.link("page");
    }
}

