/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.trigger.JenkinsTriggerJob;
import net.nemerosa.ontrack.jenkins.trigger.TriggerDefinition;
import net.nemerosa.ontrack.jenkins.trigger.TriggerHelper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackTrigger
extends Trigger<Job> {
    private static final Logger LOGGER = Logger.getLogger(OntrackTrigger.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    public static final String UNSTABLE = "UNSTABLE";
    private final String project;
    private final String branch;
    private final String promotion;
    private final String parameterName;
    private final String minimumResult;

    @DataBoundConstructor
    public OntrackTrigger(String spec, String project, String branch, String promotion, String parameterName, String minimumResult) throws ANTLRException {
        super(spec);
        this.project = project;
        this.branch = branch;
        this.promotion = promotion;
        this.parameterName = parameterName;
        this.minimumResult = minimumResult != null && !minimumResult.isEmpty() ? Result.fromString((String)minimumResult).toString() : SUCCESS;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getPromotion() {
        return this.promotion;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getMinimumResult() {
        return this.minimumResult;
    }

    public List<String> getChoices() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SUCCESS);
        list.add(UNSTABLE);
        list.add(FAILURE);
        return list;
    }

    public void run() {
        if (this.job == null) {
            LOGGER.log(Level.WARNING, "[ontrack][trigger] Cannot run because of job being null.");
            return;
        }
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Check %s promotion trigger", ((Job)this.job).getFullName(), this.promotion));
        OntrackDSLFacade ontrack = OntrackDSLConnector.createOntrackConnector(System.out);
        TriggerHelper.evaluate(ontrack, new JenkinsTriggerJob((Job)this.job), Collections.singletonList(new TriggerDefinition(this.project, this.branch, this.promotion, this.parameterName, this.minimumResult)));
    }

    @Deprecated
    public static class OntrackTriggerCause
    extends Cause {
        public String getShortDescription() {
            return "Triggered by Ontrack.";
        }

        public boolean equals(Object o) {
            return o instanceof OntrackTriggerCause;
        }
    }

    @Extension
    @Symbol(value={"ontrackTrigger"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        @Nonnull
        public String getDisplayName() {
            return "Ontrack: trigger";
        }
    }
}

