/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Map;
import net.nemerosa.ontrack.dsl.http.OTHttpClientException;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.ScriptLocation;
import net.nemerosa.ontrack.jenkins.dsl.JenkinsConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLResult;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLRunner;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackDSLStep
extends Builder {
    private final boolean usingText;
    private final String scriptPath;
    private final String scriptText;
    private final boolean sandbox;
    private final String injectEnvironment;
    private final String injectProperties;
    private final boolean ontrackLog;
    private final boolean ignoreFailure;

    @DataBoundConstructor
    public OntrackDSLStep(ScriptLocation ontrackScriptLocation, boolean sandbox, String injectEnvironment, String injectProperties, boolean ontrackLog, boolean ignoreFailure) {
        this.usingText = ontrackScriptLocation == null || ontrackScriptLocation.isUsingText();
        this.scriptPath = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptPath();
        this.scriptText = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptText();
        this.sandbox = sandbox;
        this.injectEnvironment = injectEnvironment;
        this.injectProperties = injectProperties;
        this.ontrackLog = ontrackLog;
        this.ignoreFailure = ignoreFailure;
    }

    public boolean isUsingText() {
        return this.usingText;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getInjectEnvironment() {
        return this.injectEnvironment;
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public boolean isOntrackLog() {
        return this.ontrackLog;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        block6: {
            String script = OntrackPluginSupport.readScript(theBuild, this.usingText, this.scriptText, this.scriptPath);
            JenkinsConnector jenkins = new JenkinsConnector((Run)theBuild, (TaskListener)listener, runInfo -> {});
            OntrackDSLRunner dsl = OntrackDSLRunner.getRunnerForBuild((Item)theBuild.getProject(), (TaskListener)listener).injectEnvironment(this.injectEnvironment, (Run)theBuild, (TaskListener)listener).injectProperties(this.injectProperties, (Run)theBuild, (TaskListener)listener).setLogging(this.ontrackLog).setSandbox(this.sandbox).addBinding("jenkins", jenkins).addBinding("out", listener.getLogger());
            try {
                Object dslResult = dsl.run(script);
                Result result = OntrackDSLResult.toJenkinsResult(dslResult);
                listener.getLogger().format("Ontrack DSL script result evaluated to %s%n", result);
                this.setBuildResult(theBuild, result);
                for (Map.Entry<String, String> entry : jenkins.env().entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    listener.getLogger().format("Ontrack DSL: setting %s = %s%n", name, value);
                    theBuild.addAction((Action)new ParametersAction(new ParameterValue[]{new StringParameterValue(name, value)}));
                }
            }
            catch (OTMessageClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (!this.ignoreFailure) {
                    this.setBuildResult(theBuild, Result.FAILURE);
                }
            }
            catch (OTHttpClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (this.ontrackLog) {
                    ex.printStackTrace(listener.getLogger());
                }
                if (this.ignoreFailure) break block6;
                this.setBuildResult(theBuild, Result.FAILURE);
            }
        }
        return true;
    }

    private void setBuildResult(AbstractBuild<?, ?> theBuild, Result result) {
        Result currentResult = theBuild.getResult();
        if (currentResult != null) {
            theBuild.setResult(currentResult.combine(result));
        } else {
            theBuild.setResult(result);
        }
    }

    @Extension
    public static class OntrackDSLStepDescription
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: DSL";
        }
    }
}

