/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import net.nemerosa.ontrack.jenkins.AbstractOntrackNotifier;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.BranchFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.BuildFacade;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackBuildNotifier
extends AbstractOntrackNotifier {
    private final String project;
    private final String branch;
    private final String build;
    private final boolean ignoreFailure;
    private final boolean runInfo;

    @DataBoundConstructor
    public OntrackBuildNotifier(String project, String branch, String build, boolean ignoreFailure, boolean runInfo) {
        this.project = project;
        this.branch = branch;
        this.build = build;
        this.ignoreFailure = ignoreFailure;
        this.runInfo = runInfo;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public boolean isRunInfo() {
        return this.runInfo;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Result result = theBuild.getResult();
        if (result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
            String projectName = OntrackPluginSupport.expand(this.project, theBuild, listener);
            String branchName = OntrackPluginSupport.expand(this.branch, theBuild, listener);
            String buildName = OntrackPluginSupport.expand(this.build, theBuild, listener);
            String buildDescription = String.format("Build %s", theBuild);
            OntrackDSLFacade ontrack = OntrackDSLConnector.createOntrackConnector((TaskListener)listener);
            try {
                Map<String, Object> runInfo;
                BranchFacade branch = ontrack.branch(projectName, branchName);
                BuildFacade build = branch.build(buildName, buildDescription, true);
                OntrackPluginSupport.createOntrackLinks(ontrack, theBuild, build);
                OntrackConfiguration ontrackConfiguration = OntrackConfiguration.getOntrackConfiguration();
                if (ontrackConfiguration != null) {
                    build.setJenkinsBuild(ontrackConfiguration.getOntrackConfigurationName(), this.getProjectPath(theBuild), theBuild.getNumber());
                }
                if (this.runInfo && (runInfo = this.getRunInfo(theBuild, (TaskListener)listener)) != null) {
                    build.setRunInfo(runInfo);
                }
            }
            catch (Exception ex) {
                ontrack.onClientException(ex, message -> {
                    listener.getLogger().format("[ontrack] ERROR %s%n", message);
                    if (!this.ignoreFailure) {
                        theBuild.setResult(Result.FAILURE);
                    }
                });
            }
        } else {
            listener.getLogger().format("[ontrack] No creation of build since it is broken", new Object[0]);
        }
        return true;
    }

    protected String getProjectPath(AbstractBuild<?, ?> theBuild) {
        return StringUtils.replace((String)theBuild.getProject().getRelativeNameFrom((ItemGroup)Jenkins.getInstanceOrNull()), (String)"/", (String)"/job/");
    }

    @Extension
    public static final class OntrackBuildDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public OntrackBuildDescriptorImpl() {
            super(OntrackBuildNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: Build creation";
        }
    }
}

