/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.model.ParameterDefinition;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import net.nemerosa.ontrack.jenkins.dsl.DSLRunner;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLRunner;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractOntrackParameterDefinition
extends ParameterDefinition {
    private final String dsl;
    private final boolean sandbox;
    private final String valueProperty;
    private final transient DSLRunner dslRunner;
    private final String injectProperties;
    private final Map<String, Object> bindings;

    public AbstractOntrackParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, String injectProperties) {
        this(name, description, dsl, sandbox, valueProperty, null, injectProperties, Collections.emptyMap());
    }

    public AbstractOntrackParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, Map<String, Object> bindings) {
        this(name, description, dsl, sandbox, valueProperty, null, null, bindings);
    }

    public AbstractOntrackParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, DSLRunner dslRunner, String injectProperties, Map<String, Object> bindings) {
        super(name, description);
        this.dsl = dsl;
        this.valueProperty = valueProperty;
        this.dslRunner = dslRunner;
        this.sandbox = sandbox;
        this.injectProperties = injectProperties;
        this.bindings = bindings;
    }

    public String getDsl() {
        return this.dsl;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    protected Object runDSL() {
        DSLRunner runner = this.dslRunner != null ? this.dslRunner : this.createDSLRunner();
        return runner.run(this.dsl);
    }

    protected DSLRunner createDSLRunner() {
        try {
            OntrackDSLRunner runner = OntrackDSLRunner.getRunner().setSandbox(this.sandbox).injectProperties(this.injectProperties, null, null);
            if (this.bindings != null) {
                for (Map.Entry<String, Object> entry : this.bindings.entrySet()) {
                    runner = runner.addBinding(entry.getKey(), entry.getValue());
                }
            }
            return runner;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Cannot create the DSL runner", e);
        }
    }

    protected String getProperty(Object any, String property) {
        try {
            return BeanUtils.getProperty((Object)any, (String)property);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not get property %s on object %s", property, any));
        }
    }
}

