/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackPromoteStep
extends Step {
    private final String project;
    private final String branch;
    private final String build;
    private final String promotionLevel;

    @DataBoundConstructor
    public OntrackPromoteStep(@Nonnull String project, @Nonnull String branch, @Nonnull String build, @Nonnull String promotionLevel) {
        this.project = project;
        this.branch = branch;
        this.build = build;
        this.promotionLevel = promotionLevel;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.project) || StringUtils.isBlank((String)this.branch) || StringUtils.isBlank((String)this.build) || StringUtils.isBlank((String)this.promotionLevel)) {
            throw new AbortException("Ontrack promotion run not created. All mandatory properties must be supplied ('project', 'branch', 'build', 'promotionLevel').");
        }
        return new SynchronousStepExecution<Void>(context){

            protected Void run() throws Exception {
                Ontrack ontrack = OntrackDSLConnector.createOntrackConnector((TaskListener)context.get(TaskListener.class));
                Build ontrackBuild = ontrack.build(OntrackPromoteStep.this.project, OntrackPromoteStep.this.branch, OntrackPromoteStep.this.build);
                ontrackBuild.promote(OntrackPromoteStep.this.promotionLevel);
                return null;
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackPromote";
        }

        @Nonnull
        public String getDisplayName() {
            return "Promotes an Ontrack build";
        }
    }
}

