/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.dsl.Branch;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.steps.OntrackStepHelper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackBuildStep
extends Step {
    private final String project;
    private final String branch;
    private final String build;
    private String gitCommit;

    @DataBoundConstructor
    public OntrackBuildStep(@Nonnull String project, @Nonnull String branch, @Nonnull String build) {
        this.project = project;
        this.branch = branch;
        this.build = build;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    @DataBoundSetter
    public void setGitCommit(String gitCommit) {
        this.gitCommit = gitCommit;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.project) || StringUtils.isBlank((String)this.branch) || StringUtils.isBlank((String)this.build)) {
            throw new AbortException("Ontrack build not created. All mandatory properties must be supplied ('project', 'branch', 'build').");
        }
        final String buildDescription = String.format("Build %s", this.build);
        return new SynchronousStepExecution<Void>(context){

            protected Void run() throws Exception {
                Map<String, ?> runInfo;
                TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
                if (taskListener == null) {
                    throw new IllegalStateException("Cannot get any task listener.");
                }
                Run run = (Run)context.get(Run.class);
                if (run == null) {
                    throw new IllegalStateException("Cannot get any run.");
                }
                Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(taskListener);
                Branch ontrackBranch = ontrack.branch(OntrackBuildStep.this.project, OntrackBuildStep.this.branch);
                Build ontrackBuild = ontrackBranch.build(OntrackBuildStep.this.build, buildDescription, true);
                OntrackPluginSupport.createOntrackLinks(ontrack, run, ontrackBuild);
                if (StringUtils.isNotBlank((String)OntrackBuildStep.this.gitCommit)) {
                    ontrackBuild.getConfig().gitCommit(OntrackBuildStep.this.gitCommit);
                }
                if ((runInfo = OntrackStepHelper.getRunInfo(context, taskListener)) != null && !runInfo.isEmpty()) {
                    ontrackBuild.setRunInfo(runInfo);
                }
                return null;
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackBuild";
        }

        @Nonnull
        public String getDisplayName() {
            return "Creates an Ontrack build";
        }
    }
}

