/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import groovy.lang.Binding;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.OntrackLogger;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.OntrackSecurityMode;
import net.nemerosa.ontrack.jenkins.dsl.AbstractDSLLauncher;
import net.nemerosa.ontrack.jenkins.dsl.ApprovalBasedDSLLauncher;
import net.nemerosa.ontrack.jenkins.dsl.DSLRunner;
import net.nemerosa.ontrack.jenkins.dsl.DefaultDSLLauncher;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.SandboxDSLLauncher;

public class OntrackDSLRunner
implements DSLRunner {
    private Map<String, Object> bindings = new HashMap<String, Object>();
    private boolean securityEnabled = true;
    private boolean sandbox = false;
    private boolean logging = false;
    private Item source;
    private OntrackLogger ontrackLogger = new OntrackLogger(){

        public void trace(String message) {
            System.out.println(message);
        }
    };

    protected OntrackDSLRunner() {
    }

    @Override
    public Object run(String dsl) {
        AbstractDSLLauncher launcher;
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(this.ontrackLogger);
        OntrackSecurityMode securityMode = OntrackDSLRunner.getSecurityMode();
        if (securityMode == null || securityMode == OntrackSecurityMode.DEFAULT) {
            launcher = this.securityEnabled ? (this.sandbox ? new SandboxDSLLauncher(this.source) : new ApprovalBasedDSLLauncher(this.source)) : new DefaultDSLLauncher();
        } else if (securityMode == OntrackSecurityMode.NONE) {
            launcher = new DefaultDSLLauncher();
        } else if (securityMode == OntrackSecurityMode.SANDBOX) {
            launcher = new SandboxDSLLauncher(this.source);
        } else {
            throw new IllegalStateException("Unknown Ontrack security mode: " + (Object)((Object)securityMode));
        }
        Binding binding = new Binding(this.bindings);
        binding.setProperty("ontrack", (Object)ontrack);
        this.ontrackLogger.trace(String.format("Ontrack DSL script running with launcher %s...%n", launcher.getClass().getName()));
        Object shellResult = launcher.run(dsl, binding);
        if (this.logging) {
            this.ontrackLogger.trace(String.format("Ontrack DSL script returned result: %s%n", shellResult));
        } else {
            this.ontrackLogger.trace(String.format("Ontrack DSL script returned result.%n", new Object[0]));
        }
        return shellResult;
    }

    public OntrackDSLRunner setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
        return this;
    }

    public OntrackDSLRunner setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    public OntrackDSLRunner setLogging(boolean logging) {
        this.logging = logging;
        return this;
    }

    public OntrackDSLRunner setSource(Item source) {
        this.source = source;
        return this;
    }

    public OntrackDSLRunner setOntrackLogger(OntrackLogger ontrackLogger) {
        this.ontrackLogger = ontrackLogger;
        return this;
    }

    public OntrackDSLRunner setOntrackLogger(final TaskListener taskListener) {
        return this.setOntrackLogger(new OntrackLogger(){

            public void trace(String message) {
                taskListener.getLogger().println(message);
            }
        });
    }

    public OntrackDSLRunner injectEnvironment(String environmentVariables, Run run, TaskListener listener) throws IOException, InterruptedException {
        String[] names;
        for (String name : names = environmentVariables.split(",")) {
            name = name.trim();
            String value = run.getEnvironment(listener).get(name, "");
            if (value == null) continue;
            this.bindings.put(name, value);
        }
        return this;
    }

    public OntrackDSLRunner injectProperties(@CheckForNull String propertyValues, @CheckForNull Run run, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        if (propertyValues != null) {
            Map<String, String> properties = OntrackPluginSupport.parseProperties(propertyValues, run, listener);
            this.bindings.putAll(properties);
        }
        return this;
    }

    public OntrackDSLRunner addBinding(String name, Object value) {
        this.bindings.put(name, value);
        return this;
    }

    public static OntrackDSLRunner getRunnerForBuild(Item run, TaskListener listener) {
        return new OntrackDSLRunner().setSecurityEnabled(OntrackDSLRunner.isUseSecurity()).setOntrackLogger(listener).setSource(run);
    }

    private static boolean isUseSecurity() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        return jenkins != null && jenkins.isUseSecurity();
    }

    private static OntrackSecurityMode getSecurityMode() {
        OntrackConfiguration ontrackConfiguration = OntrackConfiguration.getOntrackConfiguration();
        OntrackSecurityMode securityMode = null;
        if (ontrackConfiguration != null) {
            securityMode = ontrackConfiguration.getSecurityMode();
        }
        return securityMode;
    }

    public static OntrackDSLRunner getRunner() {
        return new OntrackDSLRunner().setSecurityEnabled(OntrackDSLRunner.isUseSecurity());
    }
}

