/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Util;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScriptLocation {
    private final boolean usingText;
    private final String scriptPath;
    private final String scriptText;

    @DataBoundConstructor
    public ScriptLocation(String value, String scriptPath, String scriptText) {
        this.usingText = value == null || Boolean.parseBoolean(value);
        this.scriptPath = Util.fixEmptyAndTrim((String)scriptPath);
        this.scriptText = Util.fixEmptyAndTrim((String)scriptText);
    }

    public boolean isUsingText() {
        return this.usingText;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public static ScriptLocation text(String text) {
        return new ScriptLocation("true", null, text);
    }

    public static ScriptLocation path(String path) {
        return new ScriptLocation("false", path, null);
    }
}

