/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Map;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.ValidationRun;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.AbstractOntrackNotifier;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackValidationRunNotifier
extends AbstractOntrackNotifier {
    private final String project;
    private final String branch;
    private final String build;
    private final String validationStamp;
    private final boolean ignoreFailure;
    private final boolean runInfo;

    @DataBoundConstructor
    public OntrackValidationRunNotifier(String project, String branch, String build, String validationStamp, boolean ignoreFailure, boolean runInfo) {
        this.project = project;
        this.branch = branch;
        this.build = build;
        this.validationStamp = validationStamp;
        this.ignoreFailure = ignoreFailure;
        this.runInfo = runInfo;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getValidationStamp() {
        return this.validationStamp;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public boolean isRunInfo() {
        return this.runInfo;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        block3: {
            String projectName = OntrackPluginSupport.expand(this.project, theBuild, listener);
            String branchName = OntrackPluginSupport.expand(this.branch, theBuild, listener);
            String buildName = OntrackPluginSupport.expand(this.build, theBuild, listener);
            String validationStampName = OntrackPluginSupport.expand(this.validationStamp, theBuild, listener);
            String runStatus = this.getRunStatus(theBuild);
            Ontrack ontrack = OntrackDSLConnector.createOntrackConnector((TaskListener)listener);
            try {
                Map<String, Object> runInfo;
                Build build = ontrack.build(projectName, branchName, buildName);
                listener.getLogger().format("[ontrack] Running %s with status %s for build %s of branch %s of project %s%n", validationStampName, runStatus, buildName, branchName, projectName);
                ValidationRun validationRun = build.validate(validationStampName, runStatus);
                if (this.runInfo && (runInfo = this.getRunInfo(theBuild, (TaskListener)listener)) != null) {
                    validationRun.setRunInfo(runInfo);
                }
            }
            catch (OTMessageClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (this.ignoreFailure) break block3;
                theBuild.setResult(Result.FAILURE);
            }
        }
        return true;
    }

    private String getRunStatus(AbstractBuild<?, ?> theBuild) {
        Result result = theBuild.getResult();
        if (result != null) {
            if (result.isBetterOrEqualTo(Result.SUCCESS)) {
                return "PASSED";
            }
            if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
                return "WARNING";
            }
            if (result.equals(Result.ABORTED)) {
                return "INTERRUPTED";
            }
            return "FAILED";
        }
        return "FAILED";
    }

    @Extension
    public static final class OntrackValidationRunDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public OntrackValidationRunDescriptorImpl() {
            super(OntrackValidationRunNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: Validation run creation";
        }
    }
}

